/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends CreateFieldFix {
    private final GrNamedArgument myNamedArgument;

    public CreateFieldFromConstructorLabelFix(GrMemberOwner targetClass, GrNamedArgument namedArgument) {
        super(targetClass);
        this.myNamedArgument = namedArgument;
    }

    @Override
    @Nullable
    protected String getFieldName() {
        GrArgumentLabel label = this.myNamedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    @Override
    protected TypeConstraint[] calculateTypeConstrains() {
        GrExpression expression = this.myNamedArgument.getExpression();
        PsiType type = null;
        if (expression != null) {
            type = expression.getType();
        }
        return new TypeConstraint[]{SupertypeConstraint.create(type, type)};
    }

    @Override
    protected String[] generateModifiers() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix.isAvailable must not be null");
        }
        return super.isAvailable(project, editor, file) && this.myNamedArgument.isValid();
    }
}

