/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;

public final class GitVersion
implements Comparable<GitVersion> {
    @NonNls
    private static final MessageFormat FORMAT_4 = new MessageFormat("git version {0,number,integer}.{1,number,integer}.{2,number,integer}.{3,number,integer}", Locale.US);
    @NonNls
    private static final MessageFormat FORMAT_3 = new MessageFormat("git version {0,number,integer}.{1,number,integer}.{2,number,integer}", Locale.US);
    public static final GitVersion INVALID = new GitVersion(0, 0, 0, 0);
    public static final GitVersion MIN = new GitVersion(1, 6, 0, 0);
    private final int myMajor;
    private final int myMinor;
    private final int myRevision;
    private final int myPatchLevel;

    public GitVersion(int major, int minor, int revision, int patchLevel) {
        this.myMajor = major;
        this.myMinor = minor;
        this.myRevision = revision;
        this.myPatchLevel = patchLevel;
    }

    public static GitVersion parse(String version) {
        try {
            Object[] parsed = FORMAT_4.parse(version);
            int major = ((Long)parsed[0]).intValue();
            int minor = ((Long)parsed[1]).intValue();
            int revision = ((Long)parsed[2]).intValue();
            int patchLevel = ((Long)parsed[3]).intValue();
            return new GitVersion(major, minor, revision, patchLevel);
        }
        catch (ParseException e) {
            try {
                Object[] parsed = FORMAT_3.parse(version);
                int major = ((Long)parsed[0]).intValue();
                int minor = ((Long)parsed[1]).intValue();
                int revision = ((Long)parsed[2]).intValue();
                int patchLevel = 0;
                return new GitVersion(major, minor, revision, patchLevel);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Unsupported format of git --version output: " + version);
            }
        }
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof GitVersion && this.compareTo((GitVersion)obj) == 0;
    }

    public int hashCode() {
        return ((this.myMajor * 17 + this.myMinor) * 17 + this.myRevision) * 17 + this.myPatchLevel;
    }

    @Override
    public int compareTo(GitVersion o) {
        int d = this.myMajor - o.myMajor;
        if (d != 0) {
            return d;
        }
        d = this.myMinor - o.myMinor;
        if (d != 0) {
            return d;
        }
        d = this.myRevision - o.myRevision;
        if (d != 0) {
            return d;
        }
        return this.myPatchLevel - o.myPatchLevel;
    }

    public String toString() {
        return "" + this.myMajor + "." + this.myMinor + "." + this.myRevision + "." + this.myPatchLevel;
    }

    public boolean isLessOrEqual(GitVersion gitVersion) {
        return gitVersion != null && this.compareTo(gitVersion) <= 0;
    }
}

