#!/bin/sh
echo 'name: uniplate
version: 1.6
id: uniplate-1.6-37d562b83c97493009e7de94e639962a

license: BSD3
copyright: 2006-10, Neil Mitchell
maintainer: ndmitchell@gmail.com
stability:
homepage: http://community.haskell.org/~ndm/uniplate/
package-url:
description: Uniplate is library for writing simple and concise generic operations.
             Uniplate has similar goals to the original Scrap Your Boilerplate work,
             but is substantially simpler and faster.
             .
             To get started with Uniplate you should import one of the three following
             modules:
             .
             * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
             Most users should start by importing this module.
             .
             * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
             with substantially higher performance (around 5 times), but requires writing
             instance declarations.
             .
             * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
             by Uniplate. Both the above two modules re-export this module.
             .
             In addition, some users may want to make use of the following modules:
             .
             * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
             .
             * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
             .
             * "Data.Generics.Compos" - users transitioning from the Compos library.
             .
             * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
             to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell
pkgpath: devel/hs-uniplate
exposed: True
exposed-modules: Data.Generics.Str Data.Generics.Compos
                 Data.Generics.SYB Data.Generics.Uniplate.Data
                 Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
                 Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
                 Data.Generics.Uniplate.Zipper Data.Generics.Uniplate
                 Data.Generics.UniplateOn Data.Generics.UniplateStr
                 Data.Generics.UniplateStrOn Data.Generics.Biplate
                 Data.Generics.PlateDirect Data.Generics.PlateTypeable
                 Data.Generics.PlateData
hidden-modules: Data.Generics.PlateInternal
                Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
import-dirs: /usr/local/lib/ghc/uniplate-1.6
library-dirs: /usr/local/lib/ghc/uniplate-1.6
hs-libraries: HSuniplate-1.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         containers-0.3.0.0-ee442470d8dcc9e45f31677c400c5379
         syb-0.1.0.2-0917873f366b0be90a48082271223b4e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-uniplate-1.6/html/uniplate.haddock
haddock-html: /usr/local/share/doc/hs-uniplate-1.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
