#!/bin/sh
echo 'name: ListLike
version: 1.0.1
id: ListLike-1.0.1-101912a25d1639b6cbb5278b3a2c5ab6

license: LGPL
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
                 Data.ListLike.String Data.ListLike.Utils
hidden-modules:
import-dirs: /usr/local/lib/ghc/ListLike-1.0.1
library-dirs: /usr/local/lib/ghc/ListLike-1.0.1
hs-libraries: HSListLike-1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.1-438000c197b51c147f229b54edbf632e
         base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         containers-0.3.0.0-ee442470d8dcc9e45f31677c400c5379
         haskell98-1.0.1.1-4d2891ad99eae334ff8234bcfbddce06
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-1.0.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-1.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
