/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

class Messages {
    private static final Logger log = Logger.getLogger(Messages.class$("gnu.classpath.tools.jarsigner.Messages").getName());
    private static final String BUNDLE_NAME = "gnu.classpath.tools.jarsigner.messages";
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final Map CACHED_FORMATS;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Messages() {
    }

    public static String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return Messages.constructMessage(string, null);
        }
    }

    public static String getFormattedString(String string, Object object) {
        MessageFormat messageFormat = (MessageFormat)CACHED_FORMATS.get(string);
        if (messageFormat == null) {
            String string2 = Messages.getString(string);
            if (string2.startsWith("!")) {
                return Messages.constructMessage(string, object);
            }
            messageFormat = new MessageFormat(string2);
            CACHED_FORMATS.put(string, messageFormat);
        }
        try {
            if (object instanceof Object[]) {
                return messageFormat.format(object);
            }
            return messageFormat.format(new Object[]{object});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Configuration.DEBUG) {
                log.fine("Exception while rendering a message format keyed by [" + string + "]: " + messageFormat.toPattern());
            }
            return Messages.constructMessage(messageFormat.toPattern(), object);
        }
    }

    private static final String constructMessage(String string, Object object) {
        if (object == null) {
            return '!' + string + '!';
        }
        return '!' + string + '!' + String.valueOf(object) + '!';
    }

    static {
        BUNDLE_NAME = BUNDLE_NAME;
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
        CACHED_FORMATS = new HashMap(5);
    }
}

