/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
    }

    public DefaultTableColumnModel() {
        this.finit$();
        this.tableColumns = new Vector();
        this.selectionModel = this.createSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Null 'col' argument.");
        }
        this.tableColumns.add(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.tableColumns.size() - 1));
    }

    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n < 0) {
            return;
        }
        this.tableColumns.remove(tableColumn);
        this.fireColumnRemoved(new TableColumnModelEvent(this, n, 0));
        tableColumn.removePropertyChangeListener(this);
        this.invalidateWidthCache();
    }

    public void moveColumn(int n, int n2) {
        int n3 = this.getColumnCount();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("Index 'i' out of range.");
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("Index 'j' out of range.");
        }
        Object object = this.tableColumns.remove(n);
        this.tableColumns.add(n2, object);
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    public void setColumnMargin(int n) {
        this.columnMargin = n;
        this.fireColumnMarginChanged();
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        int n = this.tableColumns.size();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = (TableColumn)this.tableColumns.get(i);
            if (!object.equals(tableColumn.getIdentifier())) continue;
            return i;
        }
        throw new IllegalArgumentException("No TableColumn with that identifier.");
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.tableColumns.get(n);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int n) {
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            int n2 = ((TableColumn)this.tableColumns.get(i)).getWidth();
            if (n >= 0 && n < n2) {
                return i;
            }
            n -= n2;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel.removeListSelectionListener(this);
        this.selectionModel = listSelectionModel;
        this.selectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int[] getSelectedColumns() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = this.getSelectedColumnCount();
        int[] nArray = new int[n];
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        ArrayList arrayList = new ArrayList();
        if (n2 != -1 && n3 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    nArray[0] = n2;
                    break;
                }
                case 1: {
                    int n5 = n2;
                    while (n5 <= n3) {
                        nArray[n4++] = n5++;
                    }
                    break;
                }
                case 2: {
                    for (int i = n2; i <= n3; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        nArray[n4++] = i;
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    public int getSelectedColumnCount() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = n2 - n + 1;
                    break;
                }
                case 2: {
                    for (int i = n; i <= n2; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        ++n3;
                    }
                    break;
                }
            }
        }
        return n3;
    }

    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"), tableColumnModelListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"), tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"));
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        EventListener[] eventListenerArray = this.getListeners(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((TableColumnModelListener)eventListenerArray[i]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        EventListener[] eventListenerArray = this.getListeners(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"));
        if (this.changeEvent == null && eventListenerArray.length > 0) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((TableColumnModelListener)eventListenerArray[i]).columnMarginChanged(this.changeEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("width")) {
            this.invalidateWidthCache();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            for (int i = 0; i < this.tableColumns.size(); ++i) {
                this.totalColumnWidth += ((TableColumn)this.tableColumns.get(i)).getWidth();
            }
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

