/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalScrollButton
extends BasicArrowButton {
    private static Dimension maximumSize;
    private int buttonWidth;
    private boolean freeStanding;

    public MetalScrollButton(int n, int n2, boolean bl) {
        super(n);
        this.buttonWidth = n2;
        this.freeStanding = bl;
        this.setFocusable(false);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setFreeStanding(boolean bl) {
        this.freeStanding = bl;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = SwingUtilities.getLocalBounds(this);
        if (this.getModel().isPressed()) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getControl());
        }
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        this.paintArrow(graphics, rectangle.width, rectangle.height);
        if (this.freeStanding) {
            if (this.direction == 7) {
                this.paintWestBorderFreeStanding(graphics, rectangle.width, rectangle.height);
            } else if (this.direction == 3) {
                this.paintEastBorderFreeStanding(graphics, rectangle.width, rectangle.height);
            } else if (this.direction == 5) {
                this.paintSouthBorderFreeStanding(graphics, rectangle.width, rectangle.height);
            } else {
                this.paintNorthBorderFreeStanding(graphics, rectangle.width, rectangle.height);
            }
        } else if (this.direction == 7) {
            this.paintWestBorder(graphics, rectangle.width, rectangle.height);
        } else if (this.direction == 3) {
            this.paintEastBorder(graphics, rectangle.width, rectangle.height);
        } else if (this.direction == 5) {
            this.paintSouthBorder(graphics, rectangle.width, rectangle.height);
        } else {
            this.paintNorthBorder(graphics, rectangle.width, rectangle.height);
        }
    }

    private void paintArrow(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getBlack());
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
        }
        if (this.direction == 5) {
            int n3 = n / 2;
            int n4 = n2 / 2 + 2;
            for (int i = 1; i < 5; ++i) {
                graphics.drawLine(n3 - i, n4 - i, n3 + i - 1, n4 - i);
            }
        } else if (this.direction == 3) {
            int n5 = n / 2 + 2;
            int n6 = n2 / 2;
            for (int i = 1; i < 5; ++i) {
                graphics.drawLine(n5 - i, n6 - i, n5 - i, n6 + i - 1);
            }
        } else if (this.direction == 7) {
            int n7 = n / 2 - 3;
            int n8 = n2 / 2;
            for (int i = 1; i < 5; ++i) {
                graphics.drawLine(n7 + i, n8 - i, n7 + i, n8 + i - 1);
            }
        } else {
            int n9 = n / 2;
            int n10 = n2 / 2 - 3;
            for (int i = 1; i < 5; ++i) {
                graphics.drawLine(n9 - i, n10 + i, n9 + i - 1, n10 + i);
            }
        }
    }

    private void paintNorthBorderFreeStanding(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(2, n2 - 1, n - 2, n2 - 1);
            graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.drawLine(1, 1, n - 3, 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(1, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 2, 1, n - 2, 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, 0, 0, n2 - 1);
        }
    }

    private void paintSouthBorderFreeStanding(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(2, n2 - 1, n - 2, n2 - 1);
            graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(1, 1, 1, n2 - 1);
            graphics.drawLine(1, 1, n - 1, 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(1, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, 0, 0, n2 - 1);
        }
    }

    private void paintEastBorderFreeStanding(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
            graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 1, n - 1, 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n - 2, 1, n - 2, 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        }
    }

    private void paintWestBorderFreeStanding(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(1, 1, n - 1, 1);
            graphics.drawLine(1, 1, 1, n2 - 1);
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        }
    }

    private void paintNorthBorder(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(1, 0, 1, n2 - 1);
            graphics.drawLine(1, 0, n - 1, 0);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, 0, n2 - 1);
        }
    }

    private void paintSouthBorder(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(1, 0, 1, n2 - 1);
            graphics.drawLine(1, 0, n - 1, 0);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(1, n2 - 1, 1, n2 - 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, 0, n2 - 1);
        }
    }

    private void paintEastBorder(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(n - 1, 2, n - 1, n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 1, n - 2, 1);
            graphics.drawLine(0, 1, 0, n2 - 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, n - 1, 0);
        }
    }

    private void paintWestBorder(Graphics graphics, int n, int n2) {
        Rectangle rectangle = SwingUtilities.getLocalBounds(this);
        if (this.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 1, rectangle.width - 1, 1);
            graphics.drawLine(0, 1, 0, rectangle.height - 1);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
        }
    }

    public Dimension getPreferredSize() {
        int n = 1;
        if (!this.freeStanding) {
            n = 2;
        }
        if (this.direction == 3) {
            return new Dimension(this.buttonWidth - n, this.buttonWidth);
        }
        if (this.direction == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        if (this.direction == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - n);
        }
        return new Dimension(this.buttonWidth, this.buttonWidth - 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        if (maximumSize == null) {
            maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return maximumSize;
    }
}

