/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    private static final long serialVersionUID = 3140472492599046285L;
    private URL page;
    private EditorKit editorKit;
    boolean focus_root;
    static HashMap registerMap;
    HashMap editorMap;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public JEditorPane() {
        this.init();
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JEditorPane(String string) throws IOException {
        this(new URL(string));
    }

    public JEditorPane(String string, String string2) {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType(string));
        this.setText(string2);
    }

    public JEditorPane(URL uRL) throws IOException {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.setPage(uRL);
    }

    void init() {
        this.editorMap = new HashMap();
        registerMap = new HashMap();
        JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        String string2 = (String)registerMap.get(string);
        if (string2 != null) {
            try {
                editorKit = (EditorKit)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return editorKit;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkListener[] hyperlinkListenerArray = this.getHyperlinkListeners();
        for (int i = 0; i < hyperlinkListenerArray.length; ++i) {
            hyperlinkListenerArray[i].hyperlinkUpdate(hyperlinkEvent);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML(this) : new AccessibleJEditorPane(this);
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.getEditorKit().getContentType();
    }

    public EditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        return this.editorKit;
    }

    public static String getEditorKitClassNameForContentType(String string) {
        return (String)registerMap.get(string);
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit = (EditorKit)this.editorMap.get(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(string);
        }
        if (editorKit == null) {
            editorKit = new PlainEditorKit();
        }
        return editorKit;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getScrollableTracksViewportWidth()) {
            dimension.width = this.getUI().getMinimumSize((JComponent)this).width;
        }
        if (this.getScrollableTracksViewportHeight()) {
            dimension.height = this.getUI().getMinimumSize((JComponent)this).height;
        }
        return dimension;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        return container instanceof JViewport && container.getHeight() > this.getUI().getMinimumSize((JComponent)this).height;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        return container != null && container instanceof JViewport && container.getWidth() > this.getUI().getMinimumSize((JComponent)this).width;
    }

    public URL getPage() {
        return this.page;
    }

    protected InputStream getStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    public String getText() {
        return super.getText();
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    public boolean isFocusCycleRoot() {
        return this.focus_root;
    }

    protected String paramString() {
        return "JEditorPane";
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof HTMLEditorKit && object instanceof HTMLDocument) {
            Document document = (Document)object;
            try {
                editorKit.read(inputStream, document, 0);
            }
            catch (BadLocationException badLocationException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"BadLocationException must not be thrown here.");
                }
            }
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        registerMap.put(string, string2);
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
    }

    public void replaceSelection(String string) {
        super.replaceSelection(string);
    }

    public void scrollToReference(String string) {
    }

    public final void setContentType(String string) {
        if (this.editorKit != null && this.editorKit.getContentType().equals(string)) {
            return;
        }
        EditorKit editorKit = this.getEditorKitForContentType(string);
        if (editorKit != null) {
            this.setEditorKit(editorKit);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        if (this.editorKit == editorKit) {
            return;
        }
        if (this.editorKit != null) {
            this.editorKit.deinstall(this);
        }
        EditorKit editorKit2 = this.editorKit;
        this.editorKit = editorKit;
        if (this.editorKit != null) {
            this.editorKit.install(this);
            this.setDocument(this.editorKit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
        this.invalidate();
        this.repaint();
        this.accessibleContext = null;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        this.editorMap.put(string, editorKit);
    }

    public void setPage(String string) throws IOException {
        this.setPage(new URL(string));
    }

    public void setPage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        try {
            this.page = uRL;
            this.getEditorKit().read(uRL.openStream(), this.getDocument(), 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            this.getEditorKit().read(new StringReader(string), document, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(JEditorPane.class$("javax.swing.event.HyperlinkListener"), hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(JEditorPane.class$("javax.swing.event.HyperlinkListener"), hyperlinkListener);
    }

    public HyperlinkListener[] getHyperlinkListeners() {
        return (HyperlinkListener[])this.getListeners(JEditorPane.class$("javax.swing.event.HyperlinkListener"));
    }

    static {
        $assertionsDisabled = JEditorPane.class$("javax.swing.JEditorPane").desiredAssertionStatus() ^ true;
    }

    private static class PlainEditorKit
    extends DefaultEditorKit {
        public ViewFactory getViewFactory() {
            return new ViewFactory(this){
                private /* synthetic */ PlainEditorKit this$1;
                {
                    this.this$1 = plainEditorKit;
                }

                public View create(Element element) {
                    return new WrappedPlainView(element);
                }
            };
        }

        PlainEditorKit() {
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        private /* synthetic */ JEditorPane this$0;

        static /* synthetic */ JEditorPane access$3(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport, JEditorPane jEditorPane) {
            jEditorPaneAccessibleHypertextSupport.this$0 = jEditorPane;
            return jEditorPaneAccessibleHypertextSupport.this$0;
        }

        static JEditorPane access$0(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport) {
            return jEditorPaneAccessibleHypertextSupport.this$0;
        }

        public JEditorPaneAccessibleHypertextSupport(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
        }

        public int getLinkCount() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.this$0.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n = 0;
            while (iterator.isValid()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public AccessibleHyperlink getLink(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)this.this$0.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && ++n2 != n) {
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                HTMLLink hTMLLink = new HTMLLink(this, element);
                return hTMLLink;
            }
            return null;
        }

        public int getLinkIndex(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)this.this$0.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && (iterator.getStartOffset() > n || iterator.getEndOffset() <= n)) {
                ++n2;
                iterator.next();
            }
            if (iterator.isValid()) {
                return n2;
            }
            return -1;
        }

        public String getLinkText(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)this.this$0.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && ++n2 != n) {
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                try {
                    String string = hTMLDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    return string;
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }
            return null;
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            private /* synthetic */ JEditorPaneAccessibleHypertextSupport this$1;
            Element element;

            public HTMLLink(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport, Element element) {
                this.this$1 = jEditorPaneAccessibleHypertextSupport;
                this.element = element;
            }

            public boolean isValid() {
                HTMLDocument hTMLDocument = (HTMLDocument)this.this$1.this$0.getDocument();
                return hTMLDocument.getCharacterElement(this.element.getStartOffset()) == this.element;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)this.this$1.this$0.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    this.this$1.this$0.setPage(uRL);
                    String string2 = hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPaneAccessibleHypertextSupport.access$0(this.this$1), HyperlinkEvent.EventType.ACTIVATED, uRL, string2, this.element);
                    this.this$1.this$0.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String getAccessibleActionDescription(int n) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.this$1.this$0.getDocument();
                try {
                    return hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }

            public Object getAccessibleActionObject(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)this.this$1.this$0.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        private /* synthetic */ JEditorPane this$0;

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport(this.this$0);
        }

        protected AccessibleJEditorPaneHTML(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
        }
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        private /* synthetic */ JEditorPane this$0;

        protected AccessibleJEditorPane(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                return this.this$0.getContentType();
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

