/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class JavadocProblemsConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_JAVADOC_SUPPORT = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.doc.comment.support");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef");
    private static final OptionsConfigurationBlock.Key PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTags");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocComments");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility");
    private static final OptionsConfigurationBlock.Key PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING = JavadocProblemsConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String DEFAULT = "default";
    private static final String PRIVATE = "private";
    private PixelConverter fPixelConverter;
    private Composite fJavadocComposite;
    private ControlEnableState fBlockEnableState = null;

    public JavadocProblemsConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, JavadocProblemsConfigurationBlock.getKeys(), container);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_JAVADOC_SUPPORT, PREF_PB_INVALID_JAVADOC, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_INVALID_JAVADOC_TAGS, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF, PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF, PREF_PB_MISSING_JAVADOC_TAGS, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, PREF_PB_MISSING_JAVADOC_COMMENTS, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite javadocComposite = this.createJavadocTabContent(parent);
        this.validateSettings(null, null, null);
        return javadocComposite;
    }

    private Composite createJavadocTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.JavadocProblemsConfigurationBlock_error, PreferencesMessages.JavadocProblemsConfigurationBlock_warning, PreferencesMessages.JavadocProblemsConfigurationBlock_ignore};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        String[] visibilities = new String[]{PUBLIC, PROTECTED, DEFAULT, PRIVATE};
        String[] visibilitiesLabels = new String[]{PreferencesMessages.JavadocProblemsConfigurationBlock_public, PreferencesMessages.JavadocProblemsConfigurationBlock_protected, PreferencesMessages.JavadocProblemsConfigurationBlock_default, PreferencesMessages.JavadocProblemsConfigurationBlock_private};
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite outer = sc1.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        String label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_javadoc_support_label;
        this.addCheckBox(outer, label, PREF_JAVADOC_SUPPORT, enabledDisabled, 0);
        layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        Composite composite = new Composite(outer, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.fJavadocComposite = composite;
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.JavadocProblemsConfigurationBlock_javadoc_description);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_label;
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_visibility_label;
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_label;
        this.addCheckBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS, enabledDisabled, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_not_visible_ref_label;
        this.addCheckBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF, enabledDisabled, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_invalid_javadoc_tags_deprecated_label;
        this.addCheckBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF, enabledDisabled, indent);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_tags_visibility_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_javadoc_tags_overriding_label;
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, enabledDisabled, indent);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_visibility_label;
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.JavadocProblemsConfigurationBlock_pb_missing_comments_overriding_label;
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING, enabledDisabled, indent);
        return sc1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (!PREF_PB_INVALID_JAVADOC.equals(changedKey) && !PREF_PB_MISSING_JAVADOC_TAGS.equals(changedKey) && !PREF_PB_MISSING_JAVADOC_COMMENTS.equals(changedKey) && !PREF_JAVADOC_SUPPORT.equals(changedKey)) return;
            this.updateEnableStates();
        } else {
            this.updateEnableStates();
        }
        this.fContext.statusChanged(new StatusInfo());
    }

    private void updateEnableStates() {
        boolean enableJavadoc = this.checkValue(PREF_JAVADOC_SUPPORT, ENABLED);
        this.enableConfigControls(enableJavadoc);
        if (enableJavadoc) {
            boolean enableInvalidTagsErrors = !this.checkValue(PREF_PB_INVALID_JAVADOC, IGNORE);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS).setEnabled(enableInvalidTagsErrors);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS_NOT_VISIBLE_REF).setEnabled(enableInvalidTagsErrors);
            this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS_DEPRECATED_REF).setEnabled(enableInvalidTagsErrors);
            this.setComboEnabled(PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, enableInvalidTagsErrors);
            boolean enableMissingTagsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_TAGS, IGNORE);
            this.getCheckBox(PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING).setEnabled(enableMissingTagsErrors);
            this.setComboEnabled(PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, enableMissingTagsErrors);
            boolean enableMissingCommentsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_COMMENTS, IGNORE);
            this.getCheckBox(PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING).setEnabled(enableMissingCommentsErrors);
            this.setComboEnabled(PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, enableMissingCommentsErrors);
        }
    }

    protected void enableConfigControls(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fJavadocComposite);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.JavadocProblemsConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.JavadocProblemsConfigurationBlock_needsfullbuild_message : PreferencesMessages.JavadocProblemsConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }
}

