/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.common.IIdentifiable;
import org.eclipse.ui.internal.menus.LayoutNode;

final class OrderNode
implements IIdentifiable {
    private List after;
    private List before;
    private final LayoutNode layoutNode;

    OrderNode(LayoutNode layoutNode) {
        if (layoutNode == null) {
            throw new NullPointerException("The layout node cannot be null");
        }
        this.layoutNode = layoutNode;
    }

    public final void addAfterNode(OrderNode orderNode) {
        if (this.after == null) {
            this.after = new ArrayList(1);
            this.after.add(orderNode);
            return;
        }
        LayoutNode.sortedInsert(this.after, orderNode);
    }

    public final void addBeforeNode(OrderNode orderNode) {
        if (this.before == null) {
            this.before = new ArrayList(1);
            this.before.add(orderNode);
            return;
        }
        LayoutNode.sortedInsert(this.before, orderNode);
    }

    public final void addTo(ArrayList sortedChildren) {
        if (this.before != null) {
            for (OrderNode node : this.before) {
                node.addTo(sortedChildren);
            }
        }
        sortedChildren.add(this.getLayoutNode());
        if (this.after != null) {
            for (OrderNode node : this.after) {
                node.addTo(sortedChildren);
            }
        }
    }

    public final List getAfterNodes() {
        if (this.after == null) {
            return Collections.EMPTY_LIST;
        }
        return this.after;
    }

    public final List getBeforeNodes() {
        if (this.before == null) {
            return Collections.EMPTY_LIST;
        }
        return this.before;
    }

    public final String getId() {
        return this.layoutNode.getId();
    }

    public final Object getLayoutNode() {
        return this.layoutNode;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OrderNode(");
        buffer.append(this.layoutNode);
        buffer.append(')');
        return buffer.toString();
    }
}

