/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayComposite
extends CompositeImageDescriptor {
    private ImageData backgroundImage;
    private ImageData leftImage;
    private ImageData rightImage;
    private ImageData topImage;
    private ImageData bottomImage;
    private List foregroundImages = new ArrayList();

    public OverlayComposite(ImageData background) {
        this.backgroundImage = background;
    }

    public void addForegroundImage(ImageData image) {
        this.foregroundImages.add(image);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.backgroundImage, this.getLeftBound(), this.getTopBound());
        Iterator e = this.foregroundImages.iterator();
        while (e.hasNext()) {
            this.drawImage((ImageData)e.next(), this.getLeftBound(), this.getTopBound());
        }
        if (this.topImage != null) {
            this.drawImage(this.topImage, this.getLeftBound(), 0);
        }
        if (this.bottomImage != null) {
            this.drawImage(this.bottomImage, this.getLeftBound(), height - this.bottomImage.height);
        }
        if (this.leftImage != null) {
            this.drawImage(this.leftImage, 0, this.getTopBound());
        }
        if (this.rightImage != null) {
            this.drawImage(this.rightImage, width - this.rightImage.width, this.getTopBound());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayComposite)) {
            return false;
        }
        OverlayComposite other = (OverlayComposite)((Object)o);
        return this.equals(this.backgroundImage, other.backgroundImage) && this.equals(this.leftImage, other.leftImage) && this.equals(this.rightImage, other.rightImage) && this.equals(this.topImage, other.topImage) && this.equals(this.bottomImage, other.bottomImage) && this.equals(this.foregroundImages, other.foregroundImages);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected int getLeftBound() {
        if (this.leftImage == null) {
            return 0;
        }
        return this.leftImage.width;
    }

    protected Point getSize() {
        Point size = new Point(this.backgroundImage.width, this.backgroundImage.height);
        if (this.topImage != null) {
            size.y += this.topImage.height;
        }
        if (this.bottomImage != null) {
            size.y += this.bottomImage.height;
        }
        if (this.leftImage != null) {
            size.x += this.leftImage.width;
        }
        if (this.rightImage != null) {
            size.x += this.rightImage.width;
        }
        return size;
    }

    protected int getTopBound() {
        if (this.topImage == null) {
            return 0;
        }
        return this.topImage.height;
    }

    public int hashCode() {
        return this.hashCode(this.backgroundImage) + this.hashCode(this.leftImage) + this.hashCode(this.rightImage) + this.hashCode(this.topImage) + this.hashCode(this.bottomImage) + this.hashCode(this.foregroundImages);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public void setBottomExtension(ImageData value) {
        this.bottomImage = value;
    }

    public void setLeftExtension(ImageData value) {
        this.leftImage = value;
    }

    public void setRightExtension(ImageData value) {
        this.rightImage = value;
    }

    public void setTopExtension(ImageData value) {
        this.topImage = value;
    }
}

