/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddEndPointCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11DeleteCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddEndPointAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IService;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class W11Service
extends WSDLBaseAdapter
implements IService {
    public List getEndPoints() {
        ArrayList adapterList = new ArrayList();
        ArrayList endPoints = new ArrayList();
        Iterator it = ((Service)this.target).getEPorts().iterator();
        while (it.hasNext()) {
            endPoints.add(it.next());
        }
        Collections.sort(endPoints, new EndPointComparator());
        this.populateAdapterList(endPoints, adapterList);
        return adapterList;
    }

    public String getName() {
        return ((Service)this.target).getQName().getLocalPart();
    }

    public List getFields() {
        return this.getEndPoints();
    }

    public IDescription getOwnerDescription() {
        return (IDescription)((Object)this.owner);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        actionIDs.add(ASDAddEndPointAction.ID);
        actionIDs.add(ASDDeleteAction.ID);
        if (this.isReadOnly()) {
            actionIDs.add("org.eclipse.wst.wsdl.ui.OpenInNewEditor");
        }
        return actionIDs.toArray(new String[0]);
    }

    public Command getAddEndPointCommand() {
        return new W11AddEndPointCommand((Service)this.target);
    }

    public Command getDeleteCommand() {
        return new W11DeleteCommand(this);
    }

    public Image getImage() {
        return WSDLEditorPlugin.getInstance().getImage("icons/service_obj.gif");
    }

    public String getText() {
        return "service";
    }

    public ITreeElement[] getChildren() {
        List endPoints = this.getEndPoints();
        ITreeElement[] treeElements = new ITreeElement[endPoints.size()];
        int index = 0;
        while (index < endPoints.size()) {
            treeElements[index] = (ITreeElement)endPoints.get(index);
            ++index;
        }
        return treeElements;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ITreeElement getParent() {
        return null;
    }

    private class EndPointComparator
    implements Comparator {
        private EndPointComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Port && o2 instanceof Port) {
                Binding binding1 = ((Port)o1).getEBinding();
                Binding binding2 = ((Port)o2).getEBinding();
                if (binding1 != null && binding2 == null) {
                    return -1;
                }
                if (binding1 == null && binding2 != null) {
                    return 1;
                }
                if (binding1 == null && binding2 == null) {
                    return 0;
                }
                PortType portType1 = binding1.getEPortType();
                PortType portType2 = binding2.getEPortType();
                if (portType1 != null && portType2 != null) {
                    String name1 = portType1.getQName().getLocalPart();
                    String name2 = portType2.getQName().getLocalPart();
                    return name1.compareTo(name2);
                }
                if (portType1 != null && portType2 == null) {
                    return -1;
                }
                if (portType1 == null && portType2 != null) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

