/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.contentassist.javadoc;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.javadoc.SubstitutionTextReader;

public class JavaDoc2HTMLTextReader
extends SubstitutionTextReader {
    private List fParameters;
    private String fReturn;
    private List fExceptions;
    private List fSees;
    private List fRest;

    public JavaDoc2HTMLTextReader(Reader reader) {
        super(reader);
    }

    private int getTag(StringBuffer buffer) throws IOException {
        int c = this.nextChar();
        while (c != -1 && Character.isLetter((char)c)) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContent(StringBuffer buffer, char stopChar) throws IOException {
        int c = this.nextChar();
        while (c != -1 && c != stopChar) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private String subsituteQualification(String qualification) {
        return qualification.replace('#', '.');
    }

    private void printDefinitions(StringBuffer buffer, List list, boolean firstword) {
        Iterator e = list.iterator();
        while (e.hasNext()) {
            String s = (String)e.next();
            buffer.append("<dd>");
            if (!firstword) {
                buffer.append(s);
            } else {
                buffer.append("<b>");
                int i = 0;
                while (i < s.length() && Character.isLetterOrDigit(s.charAt(i))) {
                    ++i;
                }
                if (i < s.length()) {
                    buffer.append(s.substring(0, i));
                    buffer.append("</b>");
                    buffer.append(s.substring(i));
                } else {
                    buffer.append("</b>");
                }
            }
            buffer.append("</dd>");
        }
    }

    private void print(StringBuffer buffer, String tag, List elements, boolean firstword) {
        if (!elements.isEmpty()) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            this.printDefinitions(buffer, elements, firstword);
        }
    }

    private void print(StringBuffer buffer, String tag, String content) {
        if (content != null) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            buffer.append("<dd>");
            buffer.append(content);
            buffer.append("</dd>");
        }
    }

    private void printRest(StringBuffer buffer) {
        if (!this.fRest.isEmpty()) {
            Iterator e = this.fRest.iterator();
            while (e.hasNext()) {
                Pair p = (Pair)e.next();
                buffer.append("<dt>");
                if (p.fTag != null) {
                    buffer.append(p.fTag);
                }
                buffer.append("</dt>");
                buffer.append("<dd>");
                if (p.fContent != null) {
                    buffer.append(p.fContent);
                }
                buffer.append("</dd>");
            }
        }
    }

    private String printSimpleTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<dl>");
        this.print(buffer, "Parameters:", this.fParameters, true);
        this.print(buffer, "Returns:", this.fReturn);
        this.print(buffer, "Throws:", this.fExceptions, true);
        this.print(buffer, "See Also:", this.fSees, false);
        this.printRest(buffer);
        buffer.append("</dl>");
        return buffer.toString();
    }

    private void handleTag(String tag, String tagContent) {
        tagContent = tagContent.trim();
        if ("@param".equals(tag)) {
            this.fParameters.add(tagContent);
        } else if ("@return".equals(tag)) {
            this.fReturn = tagContent;
        } else if ("@exception".equals(tag)) {
            this.fExceptions.add(tagContent);
        } else if ("@see".equals(tag)) {
            this.fSees.add(this.subsituteQualification(tagContent));
        } else if (tagContent != null) {
            this.fRest.add(new Pair(tag, tagContent));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList();
        this.fExceptions = new ArrayList();
        this.fSees = new ArrayList();
        this.fRest = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        int c = 64;
        while (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1) {
                buffer.append((char)c);
                c = this.getContent(buffer, '@');
            }
            this.handleTag(tag, buffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String tag, String tagContent) {
        if ("@link".equals(tag) || "@linkplain".equals(tag)) {
            StringTokenizer tokenizer = new StringTokenizer(tagContent);
            int count = tokenizer.countTokens();
            if (count == 1) {
                return this.subsituteQualification(tokenizer.nextToken());
            }
            if (count == 2) {
                tokenizer.nextToken();
                return tokenizer.nextToken();
            }
        }
        return null;
    }

    private String processBlockTag() throws IOException {
        int c = this.nextChar();
        if (c != 64) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('{');
            buffer.append((char)c);
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        if (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1) {
                buffer.append((char)c);
                c = this.getContent(buffer, '}');
            }
            return this.printBlockTag(tag, buffer.toString());
        }
        return null;
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 64) {
            return this.processSimpleTag();
        }
        if (c == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    private static class Pair {
        String fTag;
        String fContent;

        Pair(String tag, String content) {
            this.fTag = tag;
            this.fContent = content;
        }
    }
}

