/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.OverlayPreferenceStore;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.preferences.RubySourcePreviewerUpdater;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.ui.text.IColorManager;

class RubyEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private static final String COMPILER_TASK_TAGS = "org.rubypeople.rdt.core.compiler.taskTags";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.RubyEditorPreferencePage_multiLineComment, "color_ruby_multiline_comment"}, {PreferencesMessages.RubyEditorPreferencePage_singleLineComment, "color_ruby_singleline_comment"}, {PreferencesMessages.RubyEditorPreferencePage_rubyCommentTaskTags, "color_ruby_task"}, {PreferencesMessages.RubyEditorPreferencePage_keywords, "color_ruby_keyword"}, {PreferencesMessages.RubyEditorPreferencePage_strings, "color_ruby_string"}, {PreferencesMessages.RubyEditorPreferencePage_characters, "color_ruby_character"}, {PreferencesMessages.RubyEditorPreferencePage_commands, "color_ruby_command"}, {PreferencesMessages.RubyEditorPreferencePage_fixnums, "color_ruby_fixnum"}, {PreferencesMessages.RubyEditorPreferencePage_globals, "color_ruby_global"}, {PreferencesMessages.RubyEditorPreferencePage_regular_expressions, "color_ruby_regexp"}, {PreferencesMessages.RubyEditorPreferencePage_symbols, "color_ruby_symbol"}, {PreferencesMessages.RubyEditorPreferencePage_variables, "color_ruby_instance_variable"}, {PreferencesMessages.RubyEditorPreferencePage_others, "color_ruby_default"}};
    private final String fRubyCategory = PreferencesMessages.RubyEditorPreferencePage_coloring_category_ruby;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List fListModel = new ArrayList();
    private StructuredViewer fListViewer;
    private RubySourceViewer fPreviewViewer;
    private IColorManager fColorManager = new RubyColorManager(false);
    private FontMetrics fFontMetrics;

    public RubyEditorColoringConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        super(overlayPreferenceStore);
        int n = 0;
        int n2 = this.fSyntaxColorListModel.length;
        while (n < n2) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[n][0], this.fSyntaxColorListModel[n][1], String.valueOf(this.fSyntaxColorListModel[n][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[n][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[n][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[n][1]) + UNDERLINE));
            ++n;
        }
        overlayPreferenceStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int n = 0;
        int n2 = this.fListModel.size();
        while (n < n2) {
            HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)this.fListModel.get(n);
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, highlightingColorListItem.getColorKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getBoldKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getItalicKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getStrikethroughKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getUnderlineKey()));
            if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
                arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey()));
            }
            ++n;
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        return this.createSyntaxPage(composite);
    }

    private int convertWidthInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    private int convertHeightInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    public void initialize() {
        super.initialize();
        this.fListViewer.setInput((Object)this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.fRubyCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem highlightingColorListItem = this.getHighlightingColorListItem();
        if (highlightingColorListItem == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)highlightingColorListItem.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rGB);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(highlightingColorListItem.getUnderlineKey()));
        if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean bl = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey());
            this.fEnableCheckbox.setSelection(bl);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(bl);
            this.fColorEditorLabel.setEnabled(bl);
            this.fBoldCheckBox.setEnabled(bl);
            this.fItalicCheckBox.setEnabled(bl);
            this.fStrikethroughCheckBox.setEnabled(bl);
            this.fUnderlineCheckBox.setEnabled(bl);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite composite) {
        HighlightingColorListItem highlightingColorListItem;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Link link = new Link(composite2, 0);
        link.setText(PreferencesMessages.RubyEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)selectionEvent.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(composite2, 1);
        Label label = new Label(composite2, 16384);
        label.setText(PreferencesMessages.RubyEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(4, 1, true, false);
        composite3.setLayoutData((Object)gridData2);
        this.fListViewer = new TreeViewer(composite3, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fListViewer.setSorter(new ViewerSorter(){

            public int category(Object object) {
                if (RubyEditorColoringConfigurationBlock.this.fRubyCategory.equals(object)) {
                    return 0;
                }
                return 0;
            }
        });
        gridData2 = new GridData(1, 1, false, true);
        gridData2.heightHint = this.convertHeightInCharsToPixels(9);
        int n = 0;
        ScrollBar scrollBar = this.fListModel.iterator();
        while (scrollBar.hasNext()) {
            highlightingColorListItem = (HighlightingColorListItem)scrollBar.next();
            n = Math.max(n, this.convertWidthInCharsToPixels(highlightingColorListItem.getDisplayName().length()));
        }
        scrollBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (scrollBar != null) {
            n += scrollBar.getSize().x * 3;
        }
        gridData2.widthHint = n;
        this.fListViewer.getControl().setLayoutData((Object)gridData2);
        highlightingColorListItem = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        highlightingColorListItem.setLayout((Layout)gridLayout);
        highlightingColorListItem.setLayoutData(new GridData(1808));
        this.fEnableCheckbox = new Button((Composite)highlightingColorListItem, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.RubyEditorPreferencePage_enable);
        gridData2 = new GridData(768);
        gridData2.horizontalAlignment = 1;
        gridData2.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gridData2);
        this.fColorEditorLabel = new Label((Composite)highlightingColorListItem, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.RubyEditorPreferencePage_color);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gridData2);
        this.fSyntaxForegroundColorEditor = new ColorSelector((Composite)highlightingColorListItem);
        Button button = this.fSyntaxForegroundColorEditor.getButton();
        gridData2 = new GridData(32);
        button.setLayoutData((Object)gridData2);
        this.fBoldCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_bold);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gridData2);
        this.fItalicCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_italic);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gridData2);
        this.fStrikethroughCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_strikethrough);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gridData2);
        this.fUnderlineCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_underline);
        gridData2 = new GridData(32);
        gridData2.horizontalIndent = 20;
        gridData2.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gridData2);
        label = new Label(composite2, 16384);
        label.setText(PreferencesMessages.RubyEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control control = this.createPreviewer(composite2);
        gridData2 = new GridData(1808);
        gridData2.widthHint = this.convertWidthInCharsToPixels(20);
        gridData2.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData2);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RubyEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)RubyEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)highlightingColorListItem.getColorKey(), (RGB)RubyEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getBoldKey(), RubyEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getItalicKey(), RubyEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getStrikethroughKey(), RubyEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(highlightingColorListItem.getUnderlineKey(), RubyEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingColorListItem highlightingColorListItem = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (highlightingColorListItem instanceof SemanticHighlightingColorListItem) {
                    boolean bl = RubyEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)highlightingColorListItem).getEnableKey(), bl);
                    RubyEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(bl);
                    RubyEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(bl);
                    RubyEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(bl);
                    RubyEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(bl);
                    RubyEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(bl);
                    RubyEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(bl);
                    RubyEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(bl);
                }
            }
        });
        composite2.layout(false);
        return composite2;
    }

    private void addFiller(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private Control createPreviewer(Composite composite) {
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore chainedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), iPreferenceStore});
        this.fPreviewViewer = new RubySourceViewer(composite, null, null, false, 2816, (IPreferenceStore)chainedPreferenceStore);
        SimpleRubySourceViewerConfiguration simpleRubySourceViewerConfiguration = new SimpleRubySourceViewerConfiguration(this.fColorManager, (IPreferenceStore)chainedPreferenceStore, null, "___ruby_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)simpleRubySourceViewerConfiguration);
        Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new RubySourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, simpleRubySourceViewerConfiguration, (IPreferenceStore)chainedPreferenceStore);
        this.fPreviewViewer.setEditable(false);
        String string = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(string);
        RubyPlugin.getDefault().getRubyTextTools().setupRubyDocumentPartitioner((IDocument)document, "___ruby_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences preferences = new Preferences();
        preferences.setValue(COMPILER_TASK_TAGS, "TASK,TODO");
        return preferences;
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fListViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)object;
    }

    private void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;

        public HighlightingColorListItem(String string, String string2, String string3, String string4, String string5, String string6) {
            this.fDisplayName = string;
            this.fColorKey = string2;
            this.fBoldKey = string3;
            this.fItalicKey = string4;
            this.fStrikethroughKey = string5;
            this.fUnderlineKey = string6;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            super(string, string2, string3, string4, string5, string6);
            this.fEnableKey = string7;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        ColorListLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            return ((HighlightingColorListItem)object).getDisplayName();
        }
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        ColorListContentProvider() {
        }

        public Object[] getElements(Object object) {
            return new String[]{RubyEditorColoringConfigurationBlock.this.fRubyCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (RubyEditorColoringConfigurationBlock.this.fRubyCategory.equals(string)) {
                    return RubyEditorColoringConfigurationBlock.this.fListModel.toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof String) {
                return null;
            }
            return RubyEditorColoringConfigurationBlock.this.fRubyCategory;
        }

        public boolean hasChildren(Object object) {
            return object instanceof String;
        }
    }
}

