/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.parser.IProblem;
import org.rubypeople.rdt.internal.core.parser.DefaultProblem;
import org.rubypeople.rdt.internal.core.parser.TaskTag;

public class MarkerUtility {
    public static void createSyntaxError(IResource iResource, SyntaxException syntaxException) {
        try {
            ISourcePosition iSourcePosition = syntaxException.getPosition();
            IMarker iMarker = iResource.createMarker("org.rubypeople.rdt.core.problem");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("severity", new Integer(2));
            hashMap.put("message", "Syntax Error");
            hashMap.put("userEditable", Boolean.FALSE);
            hashMap.put("lineNumber", new Integer(iSourcePosition.getStartLine()));
            hashMap.put("charStart", new Integer(iSourcePosition.getStartOffset()));
            hashMap.put("charEnd", new Integer(iSourcePosition.getEndOffset()));
            iMarker.setAttributes(hashMap);
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
    }

    public static void removeMarkers(IResource iResource) {
        try {
            iResource.deleteMarkers("org.rubypeople.rdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
    }

    public static void createProblemMarkers(IResource iResource, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MarkerUtility.createProblemMarker(iResource, (DefaultProblem)iterator.next());
        }
    }

    public static void createProblemMarker(IResource iResource, IProblem iProblem) {
        try {
            IMarker iMarker = iResource.createMarker("org.rubypeople.rdt.core.problem");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = iProblem.isWarning() ? 1 : (iProblem.isError() ? 2 : 0);
            hashMap.put("severity", new Integer(n));
            hashMap.put("message", iProblem.getMessage());
            hashMap.put("userEditable", Boolean.FALSE);
            hashMap.put("lineNumber", new Integer(iProblem.getSourceLineNumber()));
            hashMap.put("charStart", new Integer(iProblem.getSourceStart()));
            hashMap.put("charEnd", new Integer(iProblem.getSourceEnd()));
            iMarker.setAttributes(hashMap);
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
    }

    public static void createTasks(IResource iResource, List list) throws CoreException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MarkerUtility.createTask(iResource, (TaskTag)iterator.next());
        }
    }

    private static void createTask(IResource iResource, TaskTag taskTag) throws CoreException {
        IMarker iMarker;
        int n = taskTag.getSourceLineNumber();
        if (n <= 0) {
            n = 1;
        }
        if ((iMarker = MarkerUtility.markerExists(iResource, taskTag.getMessage(), n, "org.rubypeople.rdt.core.task")) == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("priority", new Integer(taskTag.getPriority()));
            hashMap.put("message", taskTag.getMessage());
            hashMap.put("lineNumber", new Integer(n));
            hashMap.put("severity", new Integer(0));
            hashMap.put("userEditable", new Boolean(false));
            hashMap.put("transient", new Boolean(false));
            hashMap.put("charStart", new Integer(taskTag.getSourceStart()));
            hashMap.put("charEnd", new Integer(taskTag.getSourceEnd()));
            iMarker = iResource.createMarker("org.rubypeople.rdt.core.task");
            iMarker.setAttributes(hashMap);
        }
    }

    public static IMarker markerExists(IResource iResource, String string, int n, String string2) throws CoreException {
        IMarker[] iMarkerArray = iResource.findMarkers(string2, true, 0);
        int n2 = 0;
        while (n2 < iMarkerArray.length) {
            if (iMarkerArray[n2].getAttribute("lineNumber").toString().equals(String.valueOf(n)) && iMarkerArray[n2].getAttribute("message").equals(string)) {
                return iMarkerArray[n2];
            }
            ++n2;
        }
        return null;
    }
}

