/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.core.BufferChangedEvent;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IBufferChangedListener;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElement;

public class Buffer
implements IBuffer {
    protected IFile file;
    protected int flags;
    protected char[] contents;
    protected ArrayList changeListeners;
    protected IOpenable owner;
    protected int gapStart = -1;
    protected int gapEnd = -1;
    protected Object lock = new Object();
    protected static final int F_HAS_UNSAVED_CHANGES = 1;
    protected static final int F_IS_READ_ONLY = 2;
    protected static final int F_IS_CLOSED = 4;

    protected Buffer(IFile iFile, IOpenable iOpenable, boolean bl) {
        this.file = iFile;
        this.owner = iOpenable;
        if (iFile == null) {
            this.setReadOnly(bl);
        }
    }

    public void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(5);
        }
        if (!this.changeListeners.contains(iBufferChangedListener)) {
            this.changeListeners.add(iBufferChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(char[] cArray) {
        if (!this.isReadOnly()) {
            if (cArray == null || cArray.length == 0) {
                return;
            }
            int n = this.getLength();
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.moveAndResizeGap(n, cArray.length);
                System.arraycopy(cArray, 0, this.contents, n, cArray.length);
                this.gapStart += cArray.length;
                this.flags |= 1;
            }
            this.notifyChanged(new BufferChangedEvent(this, n, 0, new String(cArray)));
        }
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        this.append(string.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BufferChangedEvent bufferChangedEvent = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            bufferChangedEvent = new BufferChangedEvent(this, 0, 0, null);
            this.contents = null;
            this.flags |= 4;
        }
        this.notifyChanged(bufferChangedEvent);
        this.changeListeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(int n) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.contents != null) break block5;
                return '\u0000';
            }
            if (n < this.gapStart) {
                return this.contents[n];
            }
            int n2 = this.gapEnd - this.gapStart;
            return this.contents[n + n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getCharacters() {
        Object object = this.lock;
        synchronized (object) {
            if (this.contents == null) {
                return null;
            }
            if (this.gapStart < 0) {
                return this.contents;
            }
            int n = this.contents.length;
            char[] cArray = new char[n - this.gapEnd + this.gapStart];
            System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, n - this.gapEnd);
            return cArray;
        }
    }

    public String getContents() {
        char[] cArray = this.getCharacters();
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.contents != null) break block4;
                return -1;
            }
            int n = this.gapEnd - this.gapStart;
            return this.contents.length - n;
        }
    }

    public IOpenable getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (this.contents != null) break block6;
                return "";
            }
            if (n + n2 < this.gapStart) {
                return new String(this.contents, n, n2);
            }
            if (this.gapStart < n) {
                int n3 = this.gapEnd - this.gapStart;
                return new String(this.contents, n + n3, n2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.contents, n, this.gapStart - n);
            stringBuffer.append(this.contents, this.gapEnd, n + n2 - this.gapStart);
            return stringBuffer.toString();
        }
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean hasUnsavedChanges() {
        return (this.flags & 1) != 0;
    }

    public boolean isClosed() {
        return (this.flags & 4) != 0;
    }

    public boolean isReadOnly() {
        return (this.flags & 2) != 0;
    }

    protected void moveAndResizeGap(int n, int n2) {
        char[] cArray = null;
        int n3 = this.gapEnd - this.gapStart;
        if (n2 < 0) {
            if (n3 > 0) {
                cArray = new char[this.contents.length - n3];
                System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
                System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, cArray.length - this.gapStart);
                this.contents = cArray;
            }
            this.gapStart = this.gapEnd = n;
            return;
        }
        cArray = new char[this.contents.length + (n2 - n3)];
        int n4 = n;
        int n5 = n4 + n2;
        if (n3 == 0) {
            System.arraycopy(this.contents, 0, cArray, 0, n4);
            System.arraycopy(this.contents, n4, cArray, n5, cArray.length - n5);
        } else if (n4 < this.gapStart) {
            int n6 = this.gapStart - n4;
            System.arraycopy(this.contents, 0, cArray, 0, n4);
            System.arraycopy(this.contents, n4, cArray, n5, n6);
            System.arraycopy(this.contents, this.gapEnd, cArray, n5 + n6, this.contents.length - this.gapEnd);
        } else {
            int n7 = n4 - this.gapStart;
            System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, n7);
            System.arraycopy(this.contents, this.gapEnd + n7, cArray, n5, cArray.length - n5);
        }
        this.contents = cArray;
        this.gapStart = n4;
        this.gapEnd = n5;
    }

    protected void notifyChanged(final BufferChangedEvent bufferChangedEvent) {
        if (this.changeListeners != null) {
            int n = 0;
            int n2 = this.changeListeners.size();
            while (n < n2) {
                final IBufferChangedListener iBufferChangedListener = (IBufferChangedListener)this.changeListeners.get(n);
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                    }

                    public void run() throws Exception {
                        iBufferChangedListener.bufferChanged(bufferChangedEvent);
                    }
                });
                ++n;
            }
        }
    }

    public void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(iBufferChangedListener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, int n2, char[] cArray) {
        if (!this.isReadOnly()) {
            int n3 = cArray == null ? 0 : cArray.length;
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.moveAndResizeGap(n + n2, n3 - n2);
                int n4 = Math.min(n3, n2);
                if (n4 > 0) {
                    System.arraycopy(cArray, 0, this.contents, n, n4);
                }
                if (n2 > n3) {
                    this.gapStart -= n2 - n3;
                } else if (n3 > n2) {
                    this.gapStart += n3 - n2;
                    System.arraycopy(cArray, 0, this.contents, n, n3);
                }
                this.flags |= 1;
            }
            object = null;
            if (n3 > 0) {
                object = new String(cArray);
            }
            this.notifyChanged(new BufferChangedEvent(this, n, n2, (String)object));
        }
    }

    public void replace(int n, int n2, String string) {
        this.replace(n, n2, string == null ? null : string.toCharArray());
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws RubyModelException {
        if (this.isReadOnly() || this.file == null) {
            return;
        }
        if (!this.hasUnsavedChanges()) {
            return;
        }
        try {
            String string = null;
            try {
                string = this.file.getCharset();
            }
            catch (CoreException coreException) {}
            String string2 = this.getContents();
            if (string2 == null) {
                return;
            }
            byte[] byArray = string == null ? string2.getBytes() : string2.getBytes(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (this.file.exists()) {
                this.file.setContents((InputStream)byteArrayInputStream, bl ? 3 : 2, null);
            } else {
                this.file.create((InputStream)byteArrayInputStream, bl, null);
            }
        }
        catch (IOException iOException) {
            throw new RubyModelException(iOException, 985);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
        this.flags &= 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(char[] cArray) {
        if (this.contents == null) {
            Object object = this.lock;
            synchronized (object) {
                this.contents = cArray;
                this.flags &= 0xFFFFFFFE;
            }
            return;
        }
        if (!this.isReadOnly()) {
            String string = null;
            if (cArray != null) {
                string = new String(cArray);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.contents = cArray;
                this.flags |= 1;
                this.gapStart = -1;
                this.gapEnd = -1;
            }
            object = new BufferChangedEvent(this, 0, this.getLength(), string);
            this.notifyChanged((BufferChangedEvent)object);
        }
    }

    public void setContents(String string) {
        this.setContents(string.toCharArray());
    }

    protected void setReadOnly(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Owner: " + ((RubyElement)((Object)this.owner)).toString());
        stringBuffer.append("\nHas unsaved changes: " + this.hasUnsavedChanges());
        stringBuffer.append("\nIs readonly: " + this.isReadOnly());
        stringBuffer.append("\nIs closed: " + this.isClosed());
        stringBuffer.append("\nContents:\n");
        char[] cArray = this.getCharacters();
        if (cArray == null) {
            stringBuffer.append("<null>");
        } else {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                switch (c) {
                    case '\n': {
                        stringBuffer.append("\\n\n");
                        break;
                    }
                    case '\r': {
                        if (n2 < n - 1 && this.contents[n2 + 1] == '\n') {
                            stringBuffer.append("\\r\\n\n");
                            ++n2;
                            break;
                        }
                        stringBuffer.append("\\r\n");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

