/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitView;

public class CounterPanel
extends Composite {
    protected Text fNumberOfErrors;
    protected Text fNumberOfFailures;
    protected Text fNumberOfRuns;
    protected int fTotal;
    private final Image fErrorIcon = TestUnitView.createImage("ovr16/error_ovr.gif");
    private final Image fFailureIcon = TestUnitView.createImage("ovr16/failed_ovr.gif");

    public CounterPanel(Composite composite) {
        super(composite, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel(TestUnitMessages.getString("CounterPanel.label.runs"), null, " 0/0  ");
        this.fNumberOfErrors = this.createLabel(TestUnitMessages.getString("CounterPanel.label.errors"), this.fErrorIcon, " 0 ");
        this.fNumberOfFailures = this.createLabel(TestUnitMessages.getString("CounterPanel.label.failures"), this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String string, Image image, String string2) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(32));
        label.setFont(JFaceResources.getBannerFont());
        Text text = new Text((Composite)this, 8);
        text.setText(string2);
        text.setBackground(this.getDisplay().getSystemColor(22));
        text.setLayoutData((Object)new GridData(800));
        return text;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0);
        this.fTotal = 0;
    }

    public void setTotal(int n) {
        this.fTotal = n;
    }

    public int getTotal() {
        return this.fTotal;
    }

    public void setRunValue(int n) {
        String string = TestUnitMessages.getFormattedString("CounterPanel.runcount", new String[]{Integer.toString(n), Integer.toString(this.fTotal)});
        this.fNumberOfRuns.setText(string);
        this.fNumberOfRuns.redraw();
        this.redraw();
    }

    public void setErrorValue(int n) {
        this.fNumberOfErrors.setText(Integer.toString(n));
        this.redraw();
    }

    public void setFailureValue(int n) {
        this.fNumberOfFailures.setText(Integer.toString(n));
        this.redraw();
    }
}

