/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.NonNullParamViolation;
import edu.umd.cs.findbugs.ba.npe.NonNullSpecification;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonNullContractCollector
implements JavaClassAndMethodChooser {
    private static final boolean DEBUG_NULLARG = SystemProperties.getBoolean("fnd.debug.nullarg");
    private final ParameterNullnessPropertyDatabase nonNullParamDatabase;
    private final ParameterNullnessPropertyDatabase possiblyNullParamDatabase;
    private final List<NonNullSpecification> specificationList;

    public NonNullContractCollector(ParameterNullnessPropertyDatabase nonNullParamDatabase, ParameterNullnessPropertyDatabase possiblyNullParamDatabase) {
        this.nonNullParamDatabase = nonNullParamDatabase;
        this.possiblyNullParamDatabase = possiblyNullParamDatabase;
        this.specificationList = new LinkedList<NonNullSpecification>();
    }

    @Override
    public boolean choose(JavaClassAndMethod classAndMethod) {
        XMethod xmethod = XFactory.createXMethod(classAndMethod.getJavaClass(), classAndMethod.getMethod());
        NonNullSpecification specification = new NonNullSpecification(classAndMethod, NonNullContractCollector.wrapProperty((ParameterNullnessProperty)this.nonNullParamDatabase.getProperty(xmethod)), NonNullContractCollector.wrapProperty((ParameterNullnessProperty)this.possiblyNullParamDatabase.getProperty(xmethod)));
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Found specification: ").append(specification).toString());
        }
        this.specificationList.add(specification);
        return false;
    }

    public void findContractForCallSite(InvokeInstruction invokeInstruction, ConstantPoolGen cpg) throws ClassNotFoundException {
        Hierarchy.findInvocationLeastUpperBound(invokeInstruction, cpg, this);
    }

    public void findContractForMethod(JavaClassAndMethod classAndMethod) throws ClassNotFoundException {
        String methodName = classAndMethod.getMethod().getName();
        String signature = classAndMethod.getMethod().getSignature();
        Hierarchy.findMethod(classAndMethod.getJavaClass(), methodName, signature, (JavaClassAndMethodChooser)this);
        Hierarchy.visitSuperClassMethods(classAndMethod, this);
        Hierarchy.visitSuperInterfaceMethods(classAndMethod, this);
    }

    public void checkSpecifications(int numParams, SpecificationBuilder builder) {
        BitSet checkedParams = new BitSet();
        for (NonNullSpecification specification : this.specificationList) {
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("Check specification: ").append(specification).toString());
            }
            for (int i = 0; i < numParams; ++i) {
                if (DEBUG_NULLARG) {
                    System.out.print(new StringBuffer().append("\tParam ").append(i).toString());
                }
                if (checkedParams.get(i)) {
                    if (!DEBUG_NULLARG) continue;
                    System.out.println(" ==> already checked");
                    continue;
                }
                if (!builder.checkParam(i)) continue;
                if (specification.getCheckForNullProperty().isNonNull(i)) {
                    builder.setCheckForNullParam(i, specification);
                    checkedParams.set(i);
                    continue;
                }
                if (specification.getNonNullProperty().isNonNull(i)) {
                    builder.setNonNullParam(i, specification);
                    checkedParams.set(i);
                    continue;
                }
                if (!DEBUG_NULLARG) continue;
                System.out.println(" ==> no constraint");
            }
        }
    }

    public void getViolationList(int numParams, final BitSet nullArgSet, final List<NonNullParamViolation> violationList, final BitSet violatedParamSet) {
        SpecificationBuilder builder = new SpecificationBuilder(){

            public boolean checkParam(int param) {
                if (!this.argIsNull(param)) {
                    if (DEBUG_NULLARG) {
                        System.out.println(" ==> not null");
                    }
                    return false;
                }
                return true;
            }

            public void setNonNullParam(int param, NonNullSpecification specification) {
                if (DEBUG_NULLARG) {
                    System.out.println(" ==> @NonNull violation!");
                }
                violationList.add(new NonNullParamViolation(specification.getClassAndMethod(), param));
                violatedParamSet.set(param);
            }

            public void setCheckForNullParam(int param, NonNullSpecification specification) {
                if (DEBUG_NULLARG) {
                    System.out.println(" ==> @CheckForNull");
                }
            }

            private boolean argIsNull(int param) {
                return nullArgSet.get(param);
            }
        };
        this.checkSpecifications(numParams, builder);
    }

    public void getAnnotationSets(int numParams, final BitSet nonNullParamSet, final BitSet possiblyNullParamSet) {
        SpecificationBuilder builder = new SpecificationBuilder(){

            public boolean checkParam(int param) {
                return true;
            }

            public void setNonNullParam(int param, NonNullSpecification specification) {
                nonNullParamSet.set(param);
            }

            public void setCheckForNullParam(int param, NonNullSpecification specification) {
                possiblyNullParamSet.set(param);
            }
        };
        this.checkSpecifications(numParams, builder);
    }

    static ParameterNullnessProperty wrapProperty(ParameterNullnessProperty property) {
        return property != null ? property : new ParameterNullnessProperty();
    }

    public static interface SpecificationBuilder {
        public boolean checkParam(int var1);

        public void setNonNullParam(int var1, NonNullSpecification var2);

        public void setCheckForNullParam(int var1, NonNullSpecification var2);
    }
}

