/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.PatternElementMatch;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodePatternMatch {
    private BindingSet bindingSet;
    private PatternElementMatch lastElementMatch;
    private LinkedList<PatternElementMatch> patternElementMatchList;

    public ByteCodePatternMatch(BindingSet bindingSet, PatternElementMatch lastElementMatch) {
        this.bindingSet = bindingSet;
        this.lastElementMatch = lastElementMatch;
        this.patternElementMatchList = new LinkedList();
        while (lastElementMatch != null) {
            this.patternElementMatchList.addFirst(lastElementMatch);
            lastElementMatch = lastElementMatch.getPrev();
        }
    }

    public BindingSet getBindingSet() {
        return this.bindingSet;
    }

    public Iterator<PatternElementMatch> patternElementMatchIterator() {
        return this.patternElementMatchList.iterator();
    }

    public InstructionHandle getLabeledInstruction(String label) {
        return this.lastElementMatch != null ? this.lastElementMatch.getLabeledInstruction(label) : null;
    }

    public PatternElementMatch getFirstLabeledMatch(String label) {
        return this.lastElementMatch != null ? this.lastElementMatch.getFirstLabeledMatch(label) : null;
    }

    public PatternElementMatch getLastLabeledMatch(String label) {
        return this.lastElementMatch != null ? this.lastElementMatch.getLastLabeledMatch(label) : null;
    }
}

