/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlRegExpBreakpoint;

public class RegExpBPSettingsDialog
extends Dialog {
    PerlRegExpBreakpoint mBP;
    private Label fSourceLabel;
    private Text fSourceText;
    private Text fRegExpText;
    private Text fMatchText;
    private String mTitle;
    private Button fIgnoreCase;
    private Button fMultiLine;

    public RegExpBPSettingsDialog(Shell parentShell, PerlRegExpBreakpoint fBP) {
        super(parentShell);
        this.mBP = fBP;
        this.mTitle = "Regular Expression Breakpoint Properties";
    }

    public RegExpBPSettingsDialog(Shell parentShell, PerlRegExpBreakpoint fBP, String fTitle) {
        super(parentShell);
        this.mBP = fBP;
        this.mTitle = fTitle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.fSourceText = this.createLine(comp, "Source Line:", false, this.mBP.getSourceLine());
        this.fRegExpText = this.createLine(comp, "Regular Expression:", true, this.mBP.getRegExp());
        this.fMatchText = this.createLine(comp, "Term to Match:", true, this.mBP.getMatchText());
        this.fMultiLine = this.createBoolen(comp, "Multi Line", true, this.mBP.getMultiLine());
        this.fIgnoreCase = this.createBoolen(comp, "Ignore Case", true, this.mBP.getIgnoreCase());
        return comp;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.mTitle);
    }

    Button createBoolen(Composite fComp, String fText, boolean fWrite, boolean fVal) {
        Composite comp = new Composite(fComp, 0);
        GridLayout sourceLayout = new GridLayout();
        sourceLayout.numColumns = 3;
        sourceLayout.marginHeight = 0;
        sourceLayout.marginWidth = 0;
        sourceLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)sourceLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fSourceLabel = new Label(comp, 0);
        this.fSourceLabel.setText(fText);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fSourceLabel.setLayoutData((Object)gd);
        Button checkBox = new Button(fComp, 0x1000020);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        checkBox.setLayoutData((Object)gd);
        checkBox.setSelection(fVal);
        checkBox.setEnabled(fWrite);
        return checkBox;
    }

    Text createLine(Composite fComp, String fText, boolean fWrite, String fVal) {
        Composite comp = new Composite(fComp, 0);
        GridLayout sourceLayout = new GridLayout();
        sourceLayout.numColumns = 3;
        sourceLayout.marginHeight = 0;
        sourceLayout.marginWidth = 0;
        sourceLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)sourceLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fSourceLabel = new Label(comp, 0);
        this.fSourceLabel.setText(fText);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fSourceLabel.setLayoutData((Object)gd);
        Text text = new Text(fComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.setEditable(fWrite);
        if (fVal != null) {
            text.setText(fVal);
        }
        return text;
    }

    protected void okPressed() {
        this.mBP.setRegExp(this.fRegExpText.getText());
        this.mBP.setMatchText(this.fMatchText.getText());
        this.mBP.setMultiLine(this.fMultiLine.getSelection());
        this.mBP.setIgnoreCase(this.fIgnoreCase.getSelection());
        super.okPressed();
    }
}

