/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBCSPanel;
import ca.sqlpower.architect.swingui.DBConnectionCallBack;
import ca.sqlpower.architect.swingui.TextPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class DBCSOkAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(DBCSOkAction.class);
    private final DBCSPanel dbcsPanel;
    private JDialog newConnectionDialog;
    private boolean isNew;
    private String oldName;
    private DBConnectionCallBack connectionSelectionCallBack;
    private DataSourceCollection plDotIni;

    public DBCSOkAction(DBCSPanel dbcsPanel, boolean isNew) {
        this(dbcsPanel, isNew, ArchitectFrame.getMainInstance().getUserSettings().getPlDotIni());
    }

    public DBCSOkAction(DBCSPanel dbcsPanel, boolean isNew, DataSourceCollection plDotIni) {
        super("Ok");
        this.dbcsPanel = dbcsPanel;
        this.isNew = isNew;
        this.oldName = !isNew ? dbcsPanel.getDbcs().getName() : null;
        this.plDotIni = plDotIni;
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"DBCS Action invoked");
        ArchitectDataSource newDS = this.dbcsPanel.getDbcs();
        String curName = null;
        for (Component c : ((TextPanel)this.dbcsPanel.getComponents()[0]).getComponents()) {
            if (!"dbNameField".equals(c.getName())) continue;
            curName = ((JTextField)c).getText();
        }
        if (curName == null) {
            throw new ArchitectRuntimeException(new ArchitectException("DBCS Panel improperly intialized"));
        }
        if (this.isNew) {
            this.dbcsPanel.applyChanges();
            if ("".equals(newDS.getName().trim())) {
                JOptionPane.showMessageDialog(this.newConnectionDialog, "A connection name must have at least 1 character that is not whitespace");
                this.newConnectionDialog.setVisible(true);
            } else if (this.plDotIni.getDataSource(newDS.getName()) == null) {
                this.plDotIni.addDataSource(newDS);
                if (this.connectionSelectionCallBack != null) {
                    this.connectionSelectionCallBack.selectDBConnection(newDS);
                }
            } else {
                JOptionPane.showMessageDialog(this.newConnectionDialog, "A connection with the name \"" + curName + "\" already exists");
                this.newConnectionDialog.setVisible(true);
            }
        } else if ("".equals(curName.trim())) {
            JOptionPane.showMessageDialog(this.newConnectionDialog, "A connection name must have at least 1 character that is not whitespace");
            this.newConnectionDialog.setVisible(true);
        } else if (curName.equals(this.oldName)) {
            logger.debug((Object)"The current Name is the same as the old name");
            this.dbcsPanel.applyChanges();
        } else {
            ArchitectDataSource dataSource = this.plDotIni.getDataSource(curName);
            if (dataSource == null) {
                this.dbcsPanel.applyChanges();
            } else {
                JOptionPane.showMessageDialog(this.newConnectionDialog, "A connection with the name \"" + curName + "\" already exists");
                this.newConnectionDialog.setVisible(true);
            }
        }
    }

    public void setConnectionDialog(JDialog newConnectionDialog) {
        this.newConnectionDialog = newConnectionDialog;
    }

    public DBConnectionCallBack getConnectionSelectionCallBack() {
        return this.connectionSelectionCallBack;
    }

    public void setConnectionSelectionCallBack(DBConnectionCallBack callBack) {
        this.connectionSelectionCallBack = callBack;
    }
}

