/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.sqlrunner;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import com.darwinsys.database.DataBaseException;
import com.darwinsys.sql.Configuration;
import com.darwinsys.sql.ConfigurationManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectSQLRunnerConfigurationManager
implements ConfigurationManager {
    public List<Configuration> getConfigurations() {
        List<ArchitectDataSource> connections = ArchitectFrame.getMainInstance().getUserSettings().getConnections();
        ArrayList<Configuration> results = new ArrayList<Configuration>();
        for (ArchitectDataSource ds : connections) {
            results.add(new ArchitectDataSourceConfiguration(ds));
        }
        return results;
    }

    public Connection getConnection(Configuration conf) {
        ArchitectDataSourceConfiguration config = (ArchitectDataSourceConfiguration)conf;
        try {
            SQLDatabase db = new SQLDatabase(config.getArchitectDataSource());
            return db.getConnection();
        }
        catch (Exception e) {
            throw new DataBaseException("Could not connect:" + e.toString());
        }
    }

    static class ArchitectDataSourceConfiguration
    implements Configuration {
        private ArchitectDataSource ds;

        public ArchitectDataSourceConfiguration(ArchitectDataSource ds) {
            this.ds = ds;
        }

        public ArchitectDataSource getArchitectDataSource() {
            return this.ds;
        }

        public String toString() {
            return this.ds.getName();
        }

        public String getDbURL() {
            return this.ds.getUrl();
        }

        public String getDriverName() {
            return this.ds.getDriverClass();
        }

        public String getName() {
            return this.ds.getDisplayName();
        }

        public String getPassword() {
            return this.ds.getPass();
        }

        public String getUserName() {
            return this.ds.getUser();
        }

        public boolean hasPassword() {
            return this.getPassword() != null && this.getPassword().length() > 0;
        }

        public void setDbURL(String arg0) {
            this.ds.setUrl(arg0);
        }

        public void setDriverName(String arg0) {
            this.ds.getParentType().setJdbcDriver(arg0);
        }

        public void setName(String arg0) {
            this.ds.setDisplayName(arg0);
        }

        public void setPassword(String arg0) {
            this.ds.setPass(arg0);
        }

        public void setUserName(String arg0) {
            this.ds.setUser(arg0);
        }
    }
}

