/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstSearch {
    private Map vertexInfo;
    private int visitTime;
    private LinkedList finishOrder;

    public DepthFirstSearch(SQLDatabase db) throws ArchitectException {
        ArrayList tables = new ArrayList();
        ArchitectUtils.extractTables(db, tables);
        this.performSearch(tables);
    }

    public DepthFirstSearch(List<SQLTable> tables) throws ArchitectException {
        this.performSearch(tables);
    }

    private void performSearch(List tables) throws ArchitectException {
        this.vertexInfo = new HashMap();
        this.finishOrder = new LinkedList();
        for (SQLTable u : tables) {
            this.vertexInfo.put(u, new VertexInfo());
        }
        this.visitTime = 0;
        for (SQLTable u : tables) {
            VertexInfo vi = (VertexInfo)this.vertexInfo.get(u);
            if (!vi.isWhite()) continue;
            this.visit(u);
        }
    }

    private void visit(SQLTable u) throws ArchitectException {
        VertexInfo vi = (VertexInfo)this.vertexInfo.get(u);
        vi.setDiscoveryTime(++this.visitTime);
        for (SQLRelationship r : u.getExportedKeys()) {
            SQLTable v = r.getFkTable();
            VertexInfo vi2 = (VertexInfo)this.vertexInfo.get(v);
            if (!vi2.isWhite()) continue;
            vi2.setPredecessor(u);
            this.visit(v);
        }
        vi.setFinishTime(++this.visitTime);
        this.finishOrder.addFirst(u);
    }

    public LinkedList getFinishOrder() {
        return this.finishOrder;
    }

    private class VertexInfo {
        private int discoveryTime;
        private int finishTime;
        private SQLTable predecessor;

        private VertexInfo() {
        }

        public boolean isWhite() {
            return this.discoveryTime == 0 && this.finishTime == 0;
        }

        public boolean isGrey() {
            return this.discoveryTime != 0 && this.finishTime == 0;
        }

        public boolean isBlack() {
            return this.finishTime != 0;
        }

        public int getDiscoveryTime() {
            return this.discoveryTime;
        }

        public void setDiscoveryTime(int discoveryTime) {
            this.discoveryTime = discoveryTime;
        }

        public int getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(int finishTime) {
            this.finishTime = finishTime;
        }

        public SQLTable getPredecessor() {
            return this.predecessor;
        }

        public void setPredecessor(SQLTable predecessor) {
            this.predecessor = predecessor;
        }
    }
}

