/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_raw_proto_h
#define __nd_raw_proto_h

#include <nd.h>

/**
 * nd_raw_proto_init - initializes raw data protocol.
 *
 * The function initializes the raw protocol to make it
 * available for subsequent calls to nd_raw_proto_get().
 * This pseudo-protocol uses the ASCII/hex editor to edit
 * the packet data.
 */ 
void          nd_raw_proto_init(void);

/**
 * nd_raw_proto_get - returns raw data protocol.
 *
 * The function returns the raw protocol. The same pointer
 * is returned each time.
 *
 * Returns: protocol.
 */
ND_Protocol  *nd_raw_proto_get(void);

/**
 * nd_raw_proto_get_gui - returns GUI handles for the raw data protocol.
 * @trace: trace whose raw data protocol information to find.
 *
 * Returns: the GUI part of the raw protocol.
 */
ND_ProtoInfo *nd_raw_proto_get_gui(LND_Trace *trace);

#endif
