/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import xni.ObjectFactory;

public class Writer
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.XIncludeAwareParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected static final boolean DEFAULT_INCREMENTAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected boolean fSeenRootElement;

    public Writer(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        ((XMLParser)this).fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = false;
        this.fElementDepth = 0;
        if (!this.fCanonical) {
            this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fOut.flush();
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(n2));
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(n2));
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print("/>");
        this.fOut.flush();
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.print("<?");
        this.fOut.print(string);
        if (xMLString != null && xMLString.length > 0) {
            this.fOut.print(' ');
            this.fOut.print(xMLString.toString());
        }
        this.fOut.print("?>");
        if (!this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.flush();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fCanonical) {
            if (this.fSeenRootElement && this.fElementDepth == 0) {
                this.fOut.print('\n');
            }
            this.fOut.print("<!--");
            this.fOut.print(xMLString.toString());
            this.fOut.print("-->");
            if (!this.fSeenRootElement) {
                this.fOut.print('\n');
            }
            this.fOut.flush();
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.normalizeAndPrint(xMLString);
        this.fOut.flush();
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
        this.fOut.flush();
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(qName.rawname);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void normalizeAndPrint(String string) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
    }

    protected void normalizeAndPrint(XMLString xMLString) {
        int n = 0;
        while (n < xMLString.length) {
            this.normalizeAndPrint(xMLString.ch[xMLString.offset + n]);
            ++n;
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = 0;
        while (var10_10 < var0.length) {
            block46: {
                var11_11 = var0[var10_10];
                if (!var11_11.startsWith("-")) ** GOTO lbl-1000
                var12_12 = var11_11.substring(1);
                if (var12_12.equals("p")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var13_21 = var0[var10_10];
                    try {
                        var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance(var13_21, ObjectFactory.findClassLoader(), true);
                        var1_1 = null;
                    }
                    catch (Exception var14_25) {
                        var2_2 = null;
                        System.err.println("error: Unable to instantiate parser configuration (" + var13_21 + ")");
                        var14_25.printStackTrace(System.err);
                    }
                } else if (var12_12.equalsIgnoreCase("n")) {
                    var3_3 = var12_12.equals("n");
                } else if (var12_12.equalsIgnoreCase("v")) {
                    var4_4 = var12_12.equals("v");
                } else if (var12_12.equalsIgnoreCase("s")) {
                    var5_5 = var12_12.equals("s");
                } else if (var12_12.equalsIgnoreCase("f")) {
                    var6_6 = var12_12.equals("f");
                } else if (var12_12.equalsIgnoreCase("hs")) {
                    var7_7 = var12_12.equals("hs");
                } else if (var12_12.equalsIgnoreCase("c")) {
                    var8_8 = var12_12.equals("c");
                } else if (var12_12.equalsIgnoreCase("i")) {
                    var9_9 = var12_12.equals("i");
                } else if (var12_12.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    block49: {
                        block48: {
                            block47: {
                                if (var2_2 == null) {
                                    try {
                                        var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance("org.apache.xerces.parsers.XIncludeAwareParserConfiguration", ObjectFactory.findClassLoader(), true);
                                    }
                                    catch (Exception var12_13) {
                                        System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.XIncludeAwareParserConfiguration)");
                                        var12_13.printStackTrace(System.err);
                                        break block46;
                                    }
                                }
                                if (var1_1 == null) {
                                    var1_1 = new Writer(var2_2);
                                }
                                try {
                                    var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                                }
                                catch (XMLConfigurationException var12_14) {
                                    System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                                }
                                try {
                                    var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                                }
                                catch (XMLConfigurationException var12_15) {
                                    System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                                }
                                try {
                                    var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                                }
                                catch (XMLConfigurationException var12_16) {
                                    if (var12_16.getType() != 1) break block47;
                                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                                }
                            }
                            try {
                                var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                            }
                            catch (XMLConfigurationException var12_17) {
                                if (var12_17.getType() != 1) break block48;
                                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                            }
                        }
                        try {
                            var2_2.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", var7_7);
                        }
                        catch (XMLConfigurationException var12_18) {
                            if (var12_18.getType() != 1) break block49;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                        }
                    }
                    try {
                        var1_1.setOutput(System.out, "UTF8");
                    }
                    catch (UnsupportedEncodingException var12_19) {
                        System.err.println("error: Unable to set output. Exiting.");
                        System.exit(1);
                    }
                    var1_1.setCanonical(var8_8);
                    try {
                        if (var9_9 && var2_2 instanceof XMLPullParserConfiguration) {
                            var12_12 = (XMLPullParserConfiguration)var2_2;
                            var12_12.setInputSource(new XMLInputSource(null, var11_11, null));
                            var13_22 = true;
                            while (var12_12.parse(false)) {
                            }
                        } else {
                            var1_1.parse(new XMLInputSource(null, var11_11, null));
                        }
                    }
                    catch (XMLParseException var12_20) {
                    }
                    catch (Exception var13_23) {
                        System.err.println("error: Parse error occurred - " + var13_23.getMessage());
                        if (var13_23 instanceof XNIException) {
                            var13_24 = ((XNIException)var13_23).getException();
                        }
                        var13_24.printStackTrace(System.err);
                    }
                }
            }
            ++var10_10;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser configuration by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -i | -I     Incremental mode.");
        System.err.println("              NOTE: This feature only works if the configuration used");
        System.err.println("                    implements XMLPullParserConfiguration.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Config:     org.apache.xerces.parsers.XIncludeAwareParserConfiguration");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Incremental:  ");
        System.err.println("off");
    }
}

