/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.xml.sax.Attributes;

public abstract class Node {
    protected Attributes attrs;
    protected Nodes body;
    protected String text;
    protected Mark startMark;
    protected int beginJavaLine;
    protected int endJavaLine;
    protected Node parent;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$IterationTag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TryCatchFinally;

    public Node(Mark start, Node parent) {
        this.startMark = start;
        this.addToParent(parent);
    }

    public Node(Attributes attrs, Mark start, Node parent) {
        this.attrs = attrs;
        this.startMark = start;
        this.addToParent(parent);
    }

    public Node(String text, Mark start, Node parent) {
        this.text = text;
        this.startMark = start;
        this.addToParent(parent);
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public String getAttributeValue(String name) {
        return this.attrs == null ? null : this.attrs.getValue(name);
    }

    public Nodes getBody() {
        return this.body;
    }

    public void setBody(Nodes body) {
        this.body = body;
    }

    public String getText() {
        return this.text;
    }

    public Mark getStart() {
        return this.startMark;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getBeginJavaLine() {
        return this.beginJavaLine;
    }

    public void setBeginJavaLine(int begin) {
        this.beginJavaLine = begin;
    }

    public int getEndJavaLine() {
        return this.endJavaLine;
    }

    public void setEndJavaLine(int end) {
        this.endJavaLine = end;
    }

    public boolean isXmlSyntax() {
        Node r = this;
        while (!(r instanceof Root)) {
            if ((r = r.getParent()) != null) continue;
            return false;
        }
        return r.isXmlSyntax();
    }

    abstract void accept(Visitor var1) throws JasperException;

    private void addToParent(Node parent) {
        if (parent != null) {
            this.parent = parent;
            Nodes parentBody = parent.getBody();
            if (parentBody == null) {
                parentBody = new Nodes();
                parent.setBody(parentBody);
            }
            parentBody.add(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Visitor {
        protected void doVisit(Node n) throws JasperException {
        }

        protected void visitBody(Node n) throws JasperException {
            if (n.getBody() != null) {
                n.getBody().visit(this);
            }
        }

        public void visit(Root n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspRoot n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PageDirective n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(IncludeDirective n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(TaglibDirective n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(Comment n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(Declaration n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(Expression n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(Scriptlet n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(IncludeAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(ForwardAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(GetProperty n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(SetProperty n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(ParamAction n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(ParamsAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(FallBackAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(UseBean n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PlugIn n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(CustomTag n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(UninterpretedTag n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspText n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(TemplateText n) throws JasperException {
            this.doVisit(n);
        }
    }

    public static class Nodes {
        private List list;
        private Root root;

        public Nodes() {
            this.list = new Vector();
        }

        public Nodes(Root root) {
            this.root = root;
            this.list = new Vector();
            this.list.add(root);
        }

        public void add(Node n) {
            this.list.add(n);
            this.root = null;
        }

        public void visit(Visitor v) throws JasperException {
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                n.accept(v);
            }
        }

        public int size() {
            return this.list.size();
        }

        public Node getNode(int index) {
            Node n = null;
            try {
                n = (Node)this.list.get(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return n;
        }

        public Root getRoot() {
            return this.root;
        }
    }

    public static class JspAttribute {
        private String name;
        private String value;
        private boolean expression;

        JspAttribute(String name, String value, boolean expr) {
            this.name = name;
            this.value = value;
            this.expression = expr;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExpression() {
            return this.expression;
        }
    }

    public static class TemplateText
    extends Node {
        public TemplateText(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isAllSpace() {
            boolean isAllSpace = true;
            for (int i = 0; i < this.text.length(); ++i) {
                if (Character.isWhitespace(this.text.charAt(i))) continue;
                isAllSpace = false;
                break;
            }
            return isAllSpace;
        }
    }

    public static class JspText
    extends Node {
        public JspText(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class CustomTag
    extends Node {
        private String name;
        private String prefix;
        private String shortName;
        private JspAttribute[] jspAttrs;
        private TagData tagData;
        private boolean scriptless;
        private boolean hasUsebean;
        private boolean hasIncludeAction;
        private boolean hasSetProperty;
        private boolean hasScriptingVars;
        private String tagHandlerPoolName;
        private TagInfo tagInfo;
        private Class tagHandlerClass;
        private VariableInfo[] varInfos;
        private int customNestingLevel;
        private boolean implementsIterationTag;
        private boolean implementsBodyTag;
        private boolean implementsTryCatchFinally;
        private Vector atBeginScriptingVars;
        private Vector atEndScriptingVars;
        private Vector nestedScriptingVars;
        private CustomTag customTagParent;
        private Integer numCount;

        public CustomTag(Attributes attrs, Mark start, String name, String prefix, String shortName, TagInfo tagInfo, Class tagHandlerClass, Node parent) {
            super(attrs, start, parent);
            this.name = name;
            this.prefix = prefix;
            this.shortName = shortName;
            this.tagInfo = tagInfo;
            this.customNestingLevel = this.makeCustomNestingLevel();
            this.tagHandlerClass = tagHandlerClass;
            this.implementsIterationTag = (class$javax$servlet$jsp$tagext$IterationTag == null ? (class$javax$servlet$jsp$tagext$IterationTag = Node.class$("javax.servlet.jsp.tagext.IterationTag")) : class$javax$servlet$jsp$tagext$IterationTag).isAssignableFrom(tagHandlerClass);
            this.implementsBodyTag = (class$javax$servlet$jsp$tagext$BodyTag == null ? (class$javax$servlet$jsp$tagext$BodyTag = Node.class$("javax.servlet.jsp.tagext.BodyTag")) : class$javax$servlet$jsp$tagext$BodyTag).isAssignableFrom(tagHandlerClass);
            this.implementsTryCatchFinally = (class$javax$servlet$jsp$tagext$TryCatchFinally == null ? (class$javax$servlet$jsp$tagext$TryCatchFinally = Node.class$("javax.servlet.jsp.tagext.TryCatchFinally")) : class$javax$servlet$jsp$tagext$TryCatchFinally).isAssignableFrom(tagHandlerClass);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getShortName() {
            return this.shortName;
        }

        public void setJspAttributes(JspAttribute[] jspAttrs) {
            this.jspAttrs = jspAttrs;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public void setTagData(TagData tagData) {
            this.tagData = tagData;
            this.varInfos = this.tagInfo.getVariableInfo(tagData);
        }

        public TagData getTagData() {
            return this.tagData;
        }

        public void setScriptless(boolean s) {
            this.scriptless = s;
        }

        public boolean isScriptless() {
            return this.scriptless;
        }

        public void setHasUsebean(boolean u) {
            this.hasUsebean = u;
        }

        public boolean isHasUsebean() {
            return this.hasUsebean;
        }

        public void setHasIncludeAction(boolean i) {
            this.hasIncludeAction = i;
        }

        public boolean isHasIncludeAction() {
            return this.hasIncludeAction;
        }

        public void setHasSetProperty(boolean s) {
            this.hasSetProperty = s;
        }

        public boolean isHasSetProperty() {
            return this.hasSetProperty;
        }

        public void setHasScriptingVars(boolean s) {
            this.hasScriptingVars = s;
        }

        public boolean hasScriptingVars() {
            return this.hasScriptingVars;
        }

        public void setTagHandlerPoolName(String s) {
            this.tagHandlerPoolName = s;
        }

        public String getTagHandlerPoolName() {
            return this.tagHandlerPoolName;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public Class getTagHandlerClass() {
            return this.tagHandlerClass;
        }

        public boolean implementsIterationTag() {
            return this.implementsIterationTag;
        }

        public boolean implementsBodyTag() {
            return this.implementsBodyTag;
        }

        public boolean implementsTryCatchFinally() {
            return this.implementsTryCatchFinally;
        }

        public TagVariableInfo[] getTagVariableInfos() {
            return this.tagInfo.getTagVariableInfos();
        }

        public VariableInfo[] getVariableInfos() {
            return this.varInfos;
        }

        public void setCustomTagParent(CustomTag n) {
            this.customTagParent = n;
        }

        public CustomTag getCustomTagParent() {
            return this.customTagParent;
        }

        public void setNumCount(Integer count) {
            this.numCount = count;
        }

        public Integer getNumCount() {
            return this.numCount;
        }

        public void setScriptingVars(Vector vec, int scope) {
            switch (scope) {
                case 1: {
                    this.atBeginScriptingVars = vec;
                    break;
                }
                case 2: {
                    this.atEndScriptingVars = vec;
                    break;
                }
                case 0: {
                    this.nestedScriptingVars = vec;
                }
            }
        }

        public Vector getScriptingVars(int scope) {
            Vector vec = null;
            switch (scope) {
                case 1: {
                    vec = this.atBeginScriptingVars;
                    break;
                }
                case 2: {
                    vec = this.atEndScriptingVars;
                    break;
                }
                case 0: {
                    vec = this.nestedScriptingVars;
                }
            }
            return vec;
        }

        public int getCustomNestingLevel() {
            return this.customNestingLevel;
        }

        private int makeCustomNestingLevel() {
            int n = 0;
            Node p = this.parent;
            while (p != null) {
                if (p instanceof CustomTag && this.name.equals(((CustomTag)p).name)) {
                    ++n;
                }
                p = p.parent;
            }
            return n;
        }
    }

    public static class UninterpretedTag
    extends Node {
        private String tagName;

        public UninterpretedTag(Attributes attrs, Mark start, String name, Node parent) {
            super(attrs, start, parent);
            this.tagName = name;
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getName() {
            return this.tagName;
        }
    }

    public static class PlugIn
    extends Node {
        JspAttribute height;
        JspAttribute width;

        public PlugIn(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setHeight(JspAttribute height) {
            this.height = height;
        }

        public void setWidth(JspAttribute width) {
            this.width = width;
        }

        public JspAttribute getHeight() {
            return this.height;
        }

        public JspAttribute getWidth() {
            return this.width;
        }
    }

    public static class UseBean
    extends Node {
        JspAttribute beanName;

        public UseBean(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setBeanName(JspAttribute beanName) {
            this.beanName = beanName;
        }

        public JspAttribute getBeanName() {
            return this.beanName;
        }
    }

    public static class SetProperty
    extends Node {
        private JspAttribute value;

        public SetProperty(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class GetProperty
    extends Node {
        public GetProperty(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class ForwardAction
    extends Node {
        private JspAttribute page;

        public ForwardAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class IncludeAction
    extends Node {
        private JspAttribute page;

        public IncludeAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class FallBackAction
    extends Node {
        public FallBackAction(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class ParamsAction
    extends Node {
        public ParamsAction(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class ParamAction
    extends Node {
        JspAttribute value;

        public ParamAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class Scriptlet
    extends ScriptingElement {
        public Scriptlet(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public Scriptlet(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class Expression
    extends ScriptingElement {
        public Expression(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public Expression(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class Declaration
    extends ScriptingElement {
        public Declaration(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public Declaration(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static abstract class ScriptingElement
    extends Node {
        public ScriptingElement(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public ScriptingElement(Mark start, Node parent) {
            super(start, parent);
        }

        public String getText() {
            String ret = this.text;
            if (ret == null && this.body != null) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < this.body.size(); ++i) {
                    buf.append(this.body.getNode(i).getText());
                }
                ret = buf.toString();
            }
            return ret;
        }
    }

    public static class Comment
    extends Node {
        public Comment(String text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class TaglibDirective
    extends Node {
        public TaglibDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class IncludeDirective
    extends Node {
        public IncludeDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class PageDirective
    extends Node {
        private Vector imports = new Vector();

        public PageDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void addImport(String value) {
            int index;
            int start = 0;
            while ((index = value.indexOf(44, start)) != -1) {
                this.imports.add(value.substring(start, index).trim());
                start = index + 1;
            }
            if (start == 0) {
                this.imports.add(value.trim());
            } else {
                this.imports.add(value.substring(start).trim());
            }
        }

        public List getImports() {
            return this.imports;
        }
    }

    public static class JspRoot
    extends Root {
        public JspRoot(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public boolean isXmlSyntax() {
            return true;
        }
    }

    public static class Root
    extends Node {
        private Root parentRoot;

        Root(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
            Node r;
            for (r = parent; r != null && !(r instanceof Root); r = r.getParent()) {
            }
            this.parentRoot = (Root)r;
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public boolean isXmlSyntax() {
            return false;
        }

        public Root getParentRoot() {
            return this.parentRoot;
        }
    }
}

