/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.StrokingTextHandler;
import org.apache.xmlgraphics.java2d.ps.TextHandler;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSGraphics2D
extends AbstractGraphics2D {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final boolean DEBUG = false;
    protected PSGenerator gen;
    private boolean clippingDisabled = false;
    protected TextHandler fallbackTextHandler = new StrokingTextHandler(this);
    protected TextHandler customTextHandler;
    protected Color currentColour = new Color(0, 0, 0);
    private Graphics2D fmg;

    public PSGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public PSGraphics2D(boolean textAsShapes, PSGenerator gen) {
        this(textAsShapes);
        this.setPSGenerator(gen);
    }

    public PSGraphics2D(PSGraphics2D g) {
        super(g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.setPSGenerator(g.gen);
        this.clippingDisabled = g.clippingDisabled;
        this.fallbackTextHandler = g.fallbackTextHandler;
        this.customTextHandler = g.customTextHandler;
        this.currentColour = g.currentColour;
    }

    public void setPSGenerator(PSGenerator gen) {
        this.gen = gen;
    }

    public PSGenerator getPSGenerator() {
        return this.gen;
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
    }

    public TextHandler getFallbackTextHandler() {
        return this.fallbackTextHandler;
    }

    public TextHandler getCustomTextHandler() {
        return this.customTextHandler;
    }

    public void setCustomTextHandler(TextHandler handler) {
        this.customTextHandler = handler;
    }

    public Graphics create() {
        return new PSGraphics2D(this);
    }

    public void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    public void preparePainting() {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.preparePainting();
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        Dimension size = new Dimension(width, height);
        BufferedImage buf = this.buildBufferedImage(size);
        Graphics2D g = buf.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.setBackground(new Color(1, 1, 1, 0));
        g.setPaint(new Color(1, 1, 1, 0));
        g.fillRect(0, 0, width, height);
        g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
        if (!g.drawImage(img, 0, 0, observer)) {
            return false;
        }
        g.dispose();
        try {
            AffineTransform at = this.getTransform();
            this.gen.saveGraphicsState();
            this.gen.concatMatrix(at);
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            PSImageUtils.renderBitmapImage(buf, x, y, width, height, this.gen);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.preparePainting();
        System.err.println("NYI: drawImage");
        return true;
    }

    public void dispose() {
        this.gen = null;
        this.fallbackTextHandler = null;
        this.customTextHandler = null;
        this.currentColour = null;
    }

    public void processPathIterator(PathIterator iter) throws IOException {
        double[] vals = new double[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " " + this.gen.formatDouble(vals[2]) + " " + this.gen.formatDouble(vals[3]) + " " + this.gen.formatDouble(vals[4]) + " " + this.gen.formatDouble(vals[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " M");
                    break;
                }
                case 2: {
                    this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " " + this.gen.formatDouble(vals[2]) + " " + this.gen.formatDouble(vals[3]) + " QUADTO ");
                    break;
                }
                case 4: {
                    this.gen.writeln("closepath");
                    break;
                }
            }
            iter.next();
        }
    }

    public void draw(Shape s) {
        this.preparePainting();
        try {
            boolean newTransform;
            this.gen.saveGraphicsState();
            AffineTransform trans = this.getTransform();
            boolean bl = newTransform = this.gen.getCurrentState().checkTransform(trans) && !trans.isIdentity();
            if (newTransform) {
                this.gen.concatMatrix(trans);
            }
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), false);
            this.applyStroke(this.getStroke());
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
            this.processPathIterator(iter);
            this.doDrawing(false, true, false);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void writeClip(Shape s) {
        if (s == null) {
            return;
        }
        if (!this.clippingDisabled) {
            this.preparePainting();
            try {
                this.gen.writeln("newpath");
                PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
                this.processPathIterator(iter);
                this.gen.writeln("clip");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
            }
        }
    }

    protected void applyPaint(Paint paint, boolean fill) {
        this.preparePainting();
        if (paint instanceof GradientPaint) {
            System.err.println("NYI: Gradient paint");
        } else if (paint instanceof TexturePaint) {
            System.err.println("NYI: texture paint");
        }
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        try {
            if (stroke instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)stroke;
                float[] da = bs.getDashArray();
                if (da != null) {
                    this.gen.write("[");
                    for (int count = 0; count < da.length; ++count) {
                        this.gen.write(this.gen.formatDouble(da[count]));
                        if (count >= da.length - 1) continue;
                        this.gen.write(" ");
                    }
                    this.gen.write("] ");
                    float offset = bs.getDashPhase();
                    this.gen.writeln(this.gen.formatDouble(offset) + " setdash");
                }
                int ec = bs.getEndCap();
                switch (ec) {
                    case 0: {
                        this.gen.writeln("0 setlinecap");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinecap");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinecap");
                        break;
                    }
                    default: {
                        System.err.println("Unsupported line cap: " + ec);
                    }
                }
                int lj = bs.getLineJoin();
                switch (lj) {
                    case 0: {
                        this.gen.writeln("0 setlinejoin");
                        float ml = bs.getMiterLimit();
                        this.gen.writeln(this.gen.formatDouble(ml >= -1.0f ? (double)ml : 1.0) + " setmiterlimit");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinejoin");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinejoin");
                        break;
                    }
                    default: {
                        System.err.println("Unsupported line join: " + lj);
                    }
                }
                float lw = bs.getLineWidth();
                this.gen.writeln(this.gen.formatDouble(lw) + " setlinewidth");
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.preparePainting();
        System.err.println("NYI: drawRenderedImage");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.preparePainting();
        System.err.println("NYI: drawRenderableImage");
    }

    public void establishColor(Color c) throws IOException {
        StringBuffer p = new StringBuffer();
        float[] comps = c.getColorComponents(null);
        if (c.getColorSpace().getType() == 5) {
            boolean same;
            boolean bl = same = comps[0] == comps[1] && comps[0] == comps[2];
            if (same) {
                p.append(this.gen.formatDouble(comps[0]));
            } else {
                for (int i = 0; i < c.getColorSpace().getNumComponents(); ++i) {
                    if (i > 0) {
                        p.append(" ");
                    }
                    p.append(this.gen.formatDouble(comps[i]));
                }
            }
            if (same) {
                p.append(" setgray");
            } else {
                p.append(" setrgbcolor");
            }
        } else if (c.getColorSpace().getType() == 9) {
            for (int i = 0; i < c.getColorSpace().getNumComponents(); ++i) {
                if (i > 0) {
                    p.append(" ");
                }
                p.append(this.gen.formatDouble(comps[i]));
            }
            p.append(" setcmykcolor");
        } else {
            p.append(this.gen.formatDouble(comps[0]));
            p.append(" setgray");
        }
        this.gen.writeln(p.toString());
    }

    public void drawString(String s, float x, float y) {
        try {
            if (this.customTextHandler != null && !this.textAsShapes) {
                this.customTextHandler.drawString(s, x, y);
            } else {
                this.fallbackTextHandler.drawString(s, x, y);
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void fill(Shape s) {
        this.preparePainting();
        try {
            boolean newTransform;
            this.gen.saveGraphicsState();
            AffineTransform trans = this.getTransform();
            boolean bl = newTransform = this.gen.getCurrentState().checkTransform(trans) && !trans.isIdentity();
            if (newTransform) {
                this.gen.concatMatrix(trans);
            }
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), true);
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
            this.processPathIterator(iter);
            this.doDrawing(true, false, iter.getWindingRule() == 0);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) throws IOException {
        this.preparePainting();
        if (fill) {
            if (stroke) {
                if (!nonzero) {
                    this.gen.writeln("gsave fill grestore stroke");
                } else {
                    this.gen.writeln("gsave eofill grestore stroke");
                }
            } else if (!nonzero) {
                this.gen.writeln("fill");
            } else {
                this.gen.writeln("eofill");
            }
        } else {
            this.gen.writeln("stroke");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        System.err.println("NYI: setXORMode");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.err.println("NYI: copyArea");
    }
}

