/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.merge;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeRevisions;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class MergeAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Merge";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        if (root == null) {
            OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                final OutputLogger logger = this.getLogger();
                try {
                    List<String> headList = HgCommand.getHeadRevisions(root);
                    if (headList.size() <= 1) {
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"));
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
                        logger.output("");
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 1);
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String revStr = null;
                                MergeRevisions mergeDlg = new MergeRevisions(root, new File[]{root});
                                if (!mergeDlg.showDialog()) {
                                    return;
                                }
                                revStr = mergeDlg.getSelectionRevision();
                                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                                MergeAction.doMergeAction(root, revStr, logger);
                                HgUtils.forceStatusRefreshProject(context);
                                logger.output("");
                            }
                            catch (HgException.HgCommandCanceledException ex) {
                            }
                            catch (HgException ex) {
                                NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                            }
                        }
                    });
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_PROGRESS"));
    }

    public static List<String> doMergeAction(File root, String revStr, OutputLogger logger) throws HgException {
        List<String> listMerge = HgCommand.doMerge(root, revStr);
        if (listMerge != null && !listMerge.isEmpty()) {
            logger.output(listMerge);
            MergeAction.handleMergeOutput(root, listMerge, true, logger);
        }
        return listMerge;
    }

    public static void handleMergeOutput(File root, List<String> listMerge, boolean bDone, OutputLogger logger) throws HgException {
        if (listMerge == null || listMerge.isEmpty()) {
            return;
        }
        Boolean bConflicts = false;
        Boolean bMergeFailed = false;
        for (String line : listMerge) {
            if (HgCommand.isMergeAbortUncommittedMsg(line)) {
                bMergeFailed = true;
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNCOMMITTED"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
                break;
            }
            if (HgCommand.isMergeAbortMultipleHeadsMsg(line)) {
                bMergeFailed = true;
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                break;
            }
            if (HgCommand.isMergeConflictMsg(line)) {
                bConflicts = true;
                String filepath = null;
                if (Utilities.isWindows()) {
                    filepath = line.substring("merging".length(), line.length() - "failed!".length()).trim().replace("/", "\\");
                    filepath = root.getAbsolutePath() + File.separator + filepath;
                } else {
                    filepath = line.substring("conflicts detected in ".length());
                }
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_CONFLICT", (Object)filepath));
                HgCommand.createConflictFile(filepath);
            }
            if (!HgCommand.isMergeUnavailableMsg(line)) continue;
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNAVAILABLE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO"));
            logger.outputLink(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO_URL"));
        }
        if (bConflicts.booleanValue()) {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_CONFLICTS"));
        }
        if (!bMergeFailed.booleanValue() && !bConflicts.booleanValue() && bDone) {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
        }
    }

    public static void printMergeWarning(List<String> list, OutputLogger logger) {
        if (list == null || list.isEmpty() || list.size() <= 1) {
            return;
        }
        if (list.size() == 2) {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED", list));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DO_NEEDED"));
        } else {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_MULTIPLE_HEADS", (Object)list.size(), list));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_MULTIPLE_HEADS"));
        }
    }
}

