/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeformFileEncodingQueryImpl
extends FileEncodingQueryImplementation
implements AntProjectListener,
PropertyChangeListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private Map<FileObject, Charset> encodingsCache;

    public FreeformFileEncodingQueryImpl(AntProjectHelper aph, PropertyEvaluator eval) {
        this.helper = aph;
        this.evaluator = eval;
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Charset getEncoding(final FileObject file) {
        return (Charset)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Charset>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Charset run() {
                Charset toReturn = null;
                1 var2_2 = this;
                synchronized (var2_2) {
                    Set roots;
                    FileObject parent;
                    if (FreeformFileEncodingQueryImpl.this.encodingsCache == null) {
                        FreeformFileEncodingQueryImpl.this.computeEncodingsCache();
                    }
                    if (FreeformFileEncodingQueryImpl.this.encodingsCache.size() > 0 && (parent = FreeformFileEncodingQueryImpl.this.getNearestParent(roots = FreeformFileEncodingQueryImpl.this.encodingsCache.keySet(), file)) != null) {
                        toReturn = (Charset)FreeformFileEncodingQueryImpl.this.encodingsCache.get(parent);
                    }
                }
                return toReturn;
            }
        });
    }

    private FileObject getNearestParent(Set<FileObject> parents, FileObject file) {
        while (file != null) {
            if (parents.contains(file)) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    private void computeEncodingsCache() {
        HashMap<FileObject, Charset> cache = new HashMap<FileObject, Charset>(3);
        Element data = Util.getPrimaryConfigurationData(this.helper);
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl != null) {
            for (Element sourceFolderEl : XMLUtil.findSubElements((Element)foldersEl)) {
                Element encodingEl;
                String location;
                if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
                FileObject srcRoot = null;
                Element locationEl = XMLUtil.findElement((Element)sourceFolderEl, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (locationEl != null && (location = this.evaluator.evaluate(XMLUtil.findText((Node)locationEl))) != null) {
                    srcRoot = this.helper.resolveFileObject(location);
                }
                if ((encodingEl = XMLUtil.findElement((Element)sourceFolderEl, (String)"encoding", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null || srcRoot == null) continue;
                String encoding = this.evaluator.evaluate(XMLUtil.findText((Node)encodingEl));
                Charset charset = null;
                if (encoding == null) continue;
                try {
                    charset = Charset.forName(encoding);
                }
                catch (IllegalCharsetNameException icne) {
                    Exceptions.printStackTrace((Throwable)icne);
                }
                cache.put(srcRoot, charset);
            }
        }
        this.encodingsCache = cache.size() > 0 ? cache : Collections.emptyMap();
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.invalidateCache();
    }

    public void propertiesChanged(AntProjectEvent ev) {
        this.invalidateCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void invalidateCache() {
        FreeformFileEncodingQueryImpl freeformFileEncodingQueryImpl = this;
        synchronized (freeformFileEncodingQueryImpl) {
            this.encodingsCache = null;
        }
    }
}

