/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModelFactory;
import org.netbeans.modules.web.jsf.api.metamodel.Behavior;
import org.netbeans.modules.web.jsf.api.metamodel.Component;
import org.netbeans.modules.web.jsf.api.metamodel.FacesConverter;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelElement;
import org.netbeans.modules.web.jsf.api.metamodel.ModelUnit;
import org.netbeans.modules.web.jsf.api.metamodel.SystemEventListener;
import org.netbeans.modules.web.jsf.api.metamodel.Validator;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationBehaviorRenderer;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationRenderer;
import org.netbeans.modules.web.jsf.impl.metamodel.BehaviorFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ClientBehaviorRendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ComponentFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ConverterFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ElementFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.JsfModelManagers;
import org.netbeans.modules.web.jsf.impl.metamodel.ManagedBeanFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ObjectProviders;
import org.netbeans.modules.web.jsf.impl.metamodel.RendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ValidatorFinder;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class JsfModelImpl
extends JsfModelManagers
implements JsfModel {
    private final PropertyChangeSupport changeSupport;
    private ModelUnit unit;
    private List<JSFConfigModel> models;
    private JSFConfigModel facesConfigModel;
    private Map<FileObject, WeakReference<JSFConfigModel>> modelCache = new HashMap<FileObject, WeakReference<JSFConfigModel>>();
    private static final Map<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>> FINDERS = new HashMap<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>>();
    private RequestProcessor requestProcessor = new RequestProcessor();

    JsfModelImpl(ModelUnit modelUnit, AnnotationModelHelper annotationModelHelper) {
        super(annotationModelHelper);
        this.unit = modelUnit;
        this.changeSupport = new PropertyChangeSupport(this);
        this.models = new LinkedList<JSFConfigModel>();
        this.registerChangeListeners();
        this.initModels();
    }

    @Override
    public <T extends JsfModelElement> List<T> getElements(Class<T> clazz) {
        Boolean bl;
        Object object;
        ElementFinder<T> elementFinder = this.getFinder(clazz);
        Class<Object> clazz2 = elementFinder == null ? clazz : elementFinder.getConfigType();
        LinkedList<T> linkedList = new LinkedList<T>();
        for (FacesConfig facesConfig : this.getFacesConfigs()) {
            object = facesConfig.getChildren(clazz2);
            linkedList.addAll((Collection<T>)object);
        }
        JSFConfigModel jSFConfigModel = this.getMainModel();
        boolean bl2 = false;
        if (jSFConfigModel != null && (object = jSFConfigModel.getRootComponent()) != null && (bl = object.isMetaDataComplete()) != null) {
            bl2 = bl;
        }
        if (elementFinder != null && !bl2) {
            linkedList.addAll(elementFinder.getAnnotations(this));
        }
        return linkedList;
    }

    @Override
    public List<FacesConfig> getFacesConfigs() {
        ArrayList<FacesConfig> arrayList = new ArrayList<FacesConfig>();
        for (JSFConfigModel jSFConfigModel : this.getModelsVariable()) {
            FacesConfig facesConfig;
            try {
                jSFConfigModel.sync();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if ((facesConfig = jSFConfigModel.getRootComponent()) == null) continue;
            arrayList.add(facesConfig);
        }
        return arrayList;
    }

    private void synch(JSFConfigModel jSFConfigModel) {
        if (jSFConfigModel != null) {
            try {
                jSFConfigModel.sync();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    @Override
    public FacesConfig getMainConfig() {
        JSFConfigModel jSFConfigModel = this.getMainModel();
        this.synch(jSFConfigModel);
        return jSFConfigModel != null ? jSFConfigModel.getRootComponent() : null;
    }

    @Override
    public List<JSFConfigModel> getModels() {
        List<JSFConfigModel> list = this.getModelsVariable();
        for (JSFConfigModel jSFConfigModel : list) {
            try {
                jSFConfigModel.sync();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected List<AnnotationBehaviorRenderer> getClientBehaviorRenderers(String string) {
        Object object;
        FacesConfig facesConfig = this.getMainConfig();
        if (facesConfig != null && (object = facesConfig.isMetaDataComplete()) != null && ((Boolean)object).booleanValue()) {
            return Collections.emptyList();
        }
        object = this.getClientBehaviorManager().getObjects();
        ArrayList<AnnotationBehaviorRenderer> arrayList = new ArrayList<AnnotationBehaviorRenderer>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ClientBehaviorRendererImpl clientBehaviorRendererImpl = (ClientBehaviorRendererImpl)iterator.next();
            String string2 = clientBehaviorRendererImpl.getRenderKitId();
            if (!string.equals(string2)) continue;
            arrayList.add(clientBehaviorRendererImpl);
        }
        return arrayList;
    }

    @Override
    protected List<AnnotationRenderer> getRenderers(String string) {
        Object object;
        FacesConfig facesConfig = this.getMainConfig();
        if (facesConfig != null && (object = facesConfig.isMetaDataComplete()) != null && ((Boolean)object).booleanValue()) {
            return Collections.emptyList();
        }
        object = this.getRendererManager().getObjects();
        ArrayList<AnnotationRenderer> arrayList = new ArrayList<AnnotationRenderer>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            RendererImpl rendererImpl = (RendererImpl)iterator.next();
            String string2 = rendererImpl.getRenderKitId();
            if (!string.equals(string2)) continue;
            arrayList.add(rendererImpl);
        }
        return arrayList;
    }

    @Override
    protected List<SystemEventListener> getSystemEventListeners() {
        Collection collection = this.getSystemEventManager().getObjects();
        List<SystemEventListener> list = ObjectProviders.findApplicationSystemEventListeners(this.getHelper());
        ArrayList<SystemEventListener> arrayList = new ArrayList<SystemEventListener>(collection.size() + list.size());
        arrayList.addAll(collection);
        arrayList.addAll(list);
        return arrayList;
    }

    private PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    private synchronized void setModelsVariable(List<JSFConfigModel> list, JSFConfigModel jSFConfigModel) {
        this.models = list;
        this.facesConfigModel = jSFConfigModel;
    }

    private synchronized List<JSFConfigModel> getModelsVariable() {
        return this.models;
    }

    private synchronized JSFConfigModel getMainModel() {
        return this.facesConfigModel;
    }

    private JSFConfigModel createModel(FileObject fileObject) {
        JSFConfigModel jSFConfigModel = this.getCachedModel(fileObject);
        if (jSFConfigModel == null) {
            try {
                ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)true);
                Lookup lookup = modelSource.getLookup();
                lookup = new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)this)});
                modelSource = new ModelSource(lookup, true);
                jSFConfigModel = JSFConfigModelFactory.getInstance().getModel(modelSource);
                this.putCachedModel(fileObject, jSFConfigModel);
            }
            catch (CatalogModelException catalogModelException) {
                Exceptions.printStackTrace((Throwable)catalogModelException);
            }
        }
        return jSFConfigModel;
    }

    private synchronized JSFConfigModel getCachedModel(FileObject fileObject) {
        WeakReference<JSFConfigModel> weakReference = this.modelCache.get(fileObject);
        if (weakReference != null) {
            return (JSFConfigModel)weakReference.get();
        }
        return null;
    }

    private synchronized void putCachedModel(FileObject fileObject, JSFConfigModel jSFConfigModel) {
        this.modelCache.put(fileObject, new WeakReference<JSFConfigModel>(jSFConfigModel));
    }

    private void initModels() {
        LinkedList<JSFConfigModel> linkedList = new LinkedList<JSFConfigModel>();
        JSFConfigModel jSFConfigModel = null;
        FileObject fileObject = this.getUnit().getApplicationFacesConfig();
        if (fileObject != null) {
            jSFConfigModel = this.createModel(fileObject);
            linkedList.add(jSFConfigModel);
        }
        for (FileObject fileObject2 : this.getUnit().getApplicationConfigurationResources()) {
            linkedList.add(this.createModel(fileObject2));
        }
        this.setModelsVariable(linkedList, jSFConfigModel);
        this.getChangeSupport().firePropertyChange("model-changed", null, null);
    }

    private ModelUnit getUnit() {
        return this.unit;
    }

    private <T extends JsfModelElement> ElementFinder<T> getFinder(Class<T> clazz) {
        return FINDERS.get(clazz);
    }

    private void registerChangeListeners() {
        this.unit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JsfModelImpl.this.requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        JsfModelImpl.this.initModels();
                    }
                });
            }
        });
    }

    static {
        FINDERS.put(Behavior.class, new BehaviorFinder());
        FINDERS.put(Component.class, new ComponentFinder());
        FINDERS.put(FacesConverter.class, new ConverterFinder());
        FINDERS.put(FacesManagedBean.class, new ManagedBeanFinder());
        FINDERS.put(Validator.class, new ValidatorFinder());
    }
}

