/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.awt.event.ActionEvent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.NBLoginPanel;
import org.netbeans.modules.bugzilla.commands.ValidateCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ReportNBIssueAction
extends SystemAction {
    public ReportNBIssueAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(ReportNBIssueAction.class, (String)"CTL_ReportIssueAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ReportNBIssueAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                BugzillaRepository repo = NBRepositorySupport.findNbRepository();
                if (!ReportNBIssueAction.checkLogin(repo)) {
                    return;
                }
                Issue.open((Repository)repo, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkLogin(BugzillaRepository repo) {
        BugzillaConfig.getInstance().setupCredentials(repo);
        if (repo.getUsername() != null && !repo.getUsername().equals("")) {
            return true;
        }
        String errorMsg = NbBundle.getMessage(ReportNBIssueAction.class, (String)"MSG_MISSING_USERNAME_PASSWORD");
        while (NBLoginPanel.show(repo, errorMsg)) {
            ValidateCommand cmd = new ValidateCommand(repo.getTaskRepository());
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ReportNBIssueAction.class, (String)"MSG_CONNECTING_2_NBORG"));
            handle.start();
            try {
                repo.getExecutor().execute(cmd, false, false, false);
            }
            finally {
                handle.finish();
            }
            if (cmd.hasFailed()) {
                errorMsg = cmd.getErrorMessage();
                continue;
            }
            BugzillaConfig.getInstance().putRepository(repo.getID(), repo);
            return true;
        }
        repo.setCredentials(null, null, null, null);
        return false;
    }
}

