/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.common.JvmConfigReader;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.ProcessCreationException;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class StartTask
extends BasicTask<GlassfishModule.OperationState> {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    private final CommonServerSupport support;
    private List<Recognizer> recognizers;
    private FileObject jdkHome = null;
    private List<String> jvmArgs = null;

    public StartTask(CommonServerSupport support, List<Recognizer> recognizers, OperationStateListener ... stateListener) {
        this(support, recognizers, (FileObject)null, (String[])null, stateListener);
    }

    public StartTask(final CommonServerSupport support, List<Recognizer> recognizers, FileObject jdkRoot, String[] jvmArgs, OperationStateListener ... stateListener) {
        super(support.getInstanceProperties(), stateListener);
        ArrayList<OperationStateListener> listeners = new ArrayList<OperationStateListener>();
        listeners.addAll(Arrays.asList(stateListener));
        listeners.add(new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (GlassfishModule.OperationState.COMPLETED.equals((Object)newState)) {
                    RequestProcessor.getDefault().post((Runnable)new EnableComet(support));
                }
            }
        });
        this.stateListener = listeners.toArray(new OperationStateListener[listeners.size()]);
        this.support = support;
        this.recognizers = recognizers;
        this.jdkHome = jdkRoot;
        this.jvmArgs = jvmArgs != null ? Arrays.asList(StartTask.removeEscapes(jvmArgs)) : null;
    }

    private static String[] removeEscapes(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replace("\\\"", "");
        }
        return args;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Process serverProcess;
        Logger.getLogger("glassfish").log(Level.FINEST, "StartTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long start = System.currentTimeMillis();
        int port = 0;
        String host = (String)this.ip.get("host");
        if (host == null || host.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            port = Integer.valueOf((String)this.ip.get("adminPort"));
            if (port < 0 || port > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
            this.jdkHome = this.getJavaPlatformRoot(this.support);
            RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != db && "true".equals(this.ip.get("derbyStartOn"))) {
                db.start();
            }
            if (CommonServerSupport.isRunning(host, port)) {
                GlassfishModule.OperationState result = GlassfishModule.OperationState.COMPLETED;
                if ("profileMode".equals(this.ip.get("jvmMode"))) {
                    result = GlassfishModule.OperationState.FAILED;
                }
                return this.fireOperationStateChanged(result, "MSG_START_SERVER_OCCUPIED_PORT", this.instanceName);
            }
            serverProcess = this.createProcess();
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger("glassfish").log(Level.INFO, (String)this.ip.get("httpportnumber"), nfe);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", ex.getLocalizedMessage());
        }
        catch (ProcessCreationException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", ex.getLocalizedMessage());
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
        LogViewMgr logger = LogViewMgr.getInstance((String)this.ip.get("url"));
        logger.readInputStreams(this.recognizers, serverProcess.getInputStream(), serverProcess.getErrorStream());
        while (System.currentTimeMillis() - start < 120000L) {
            boolean httpLive = CommonServerSupport.isRunning(host, port);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (httpLive) {
                Logger.getLogger("glassfish").log(Level.FINE, "Server HTTP is live.");
                GlassfishModule.OperationState state = GlassfishModule.OperationState.COMPLETED;
                String messageKey = "MSG_SERVER_STARTED";
                if (!this.support.isReady(true, 30, TimeUnit.SECONDS)) {
                    state = GlassfishModule.OperationState.FAILED;
                    messageKey = "MSG_START_SERVER_FAILED";
                    logger.stopReaders();
                }
                return this.fireOperationStateChanged(state, messageKey, this.instanceName);
            }
            if (null == this.jvmArgs) continue;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    while (!CommonServerSupport.isRunning(StartTask.this.support.getHostName(), StartTask.this.support.getAdminPortNumber())) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StartTask.this.support.refresh();
                        }
                    });
                }
            });
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
        }
        Logger.getLogger("glassfish").log(Level.INFO, "V3 Failed to start, killing process: " + serverProcess + " after " + (System.currentTimeMillis() - start));
        serverProcess.destroy();
        logger.stopReaders();
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED2", this.instanceName);
    }

    private String[] createEnvironment() {
        ArrayList<String> envp = new ArrayList<String>();
        String localJdkHome = this.getJdkHome();
        if (localJdkHome != null) {
            String javaEnv = "JAVA_HOME=" + localJdkHome;
            envp.add(javaEnv);
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to set JAVA_HOME for GlassFish V3 enviroment.");
        }
        Locale currentLocale = Locale.getDefault();
        if (currentLocale.equals(new Locale("tr", "TR"))) {
            envp.add("LANG=en_US");
            envp.add("LC_ALL=en_US");
            String message = NbBundle.getMessage(StartTask.class, (String)"MSG_LocaleSwitched");
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
        this.appendSystemEnvVar(envp, "GEM_HOME");
        this.appendSystemEnvVar(envp, "GEM_PATH");
        Logger logger = Logger.getLogger("glassfish");
        if (logger.isLoggable(Level.FINE)) {
            String logmsg = "V3 Environment: ";
            for (String var : envp) {
                logmsg = logmsg + var;
                logmsg = logmsg + " ";
            }
            logger.log(Level.FINE, logmsg);
        }
        return envp.toArray(new String[envp.size()]);
    }

    private void appendSystemEnvVar(List<String> envp, String key) {
        String value = (String)this.ip.get(key);
        if (value != null && value.length() > 0) {
            envp.add(key + "=" + value);
        }
    }

    private FileObject getJavaPlatformRoot(CommonServerSupport support) throws IOException {
        FileObject retVal;
        String javaInstall = support.getInstanceProperties().get("java.platform");
        if (null == javaInstall || javaInstall.trim().length() < 1) {
            File dir = new File(this.getJdkHome());
            retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)dir));
        } else {
            File f = new File(javaInstall);
            if (f.exists()) {
                File dir = f.getParentFile().getParentFile();
                retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)dir));
            } else {
                throw new FileNotFoundException(NbBundle.getMessage(StartTask.class, (String)"MSG_INVALID_JAVA", (Object)this.instanceName, (Object)javaInstall));
            }
        }
        return retVal;
    }

    private String getJdkHome() {
        String result;
        if (null != this.jdkHome) {
            result = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath();
        } else {
            result = System.getProperty("java.home");
            if (result.endsWith(File.separatorChar + "jre")) {
                result = result.substring(0, result.length() - 4);
            }
        }
        return result;
    }

    private NbProcessDescriptor createProcessDescriptor() throws ProcessCreationException {
        HashMap<String, String> propMap;
        HashMap<String, String> argMap;
        ArrayList<String> optList;
        File ss;
        String startScript = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath() + File.separatorChar + "bin" + File.separatorChar + "java";
        if (Utilities.isWindows()) {
            startScript = startScript + ".exe";
        }
        if (!(ss = new File(startScript)).exists()) {
            throw new ProcessCreationException(null, "MSG_INVALID_JAVA", this.instanceName, startScript);
        }
        if (this.support.getInstanceProvider().requiresJdk6OrHigher() && !Util.appearsToBeJdk6OrBetter(ss)) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_JDK_ERROR", this.instanceName);
        }
        String serverHome = (String)this.ip.get("homefolder");
        File bootstrapJar = ServerUtilities.getJarName(serverHome, "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (bootstrapJar == null) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_FNF", new String[0]);
        }
        File domainDir = this.getDomainFolder();
        if (!this.readJvmArgs(domainDir, optList = new ArrayList<String>(10), argMap = new HashMap<String, String>(), propMap = new HashMap<String, String>())) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_DOMAIN_FNF", new String[0]);
        }
        if (null != this.jvmArgs) {
            optList.addAll(this.jvmArgs);
        }
        StringBuilder argumentBuf = new StringBuilder(1024);
        String classpath = this.computeClassPath(propMap, domainDir, bootstrapJar);
        if (classpath != null) {
            argumentBuf.append("-cp ");
            argumentBuf.append(classpath);
        }
        this.appendSystemVars(argMap, argumentBuf);
        this.appendJavaOpts(optList, argumentBuf);
        if (classpath != null) {
            argumentBuf.append(" ");
            argumentBuf.append(MAIN_CLASS);
        } else {
            argumentBuf.append(" -jar ");
            argumentBuf.append(Util.quote(bootstrapJar.getAbsolutePath()));
        }
        argumentBuf.append(" --domain " + this.getDomainName());
        argumentBuf.append(" --domaindir " + Util.quote(domainDir.getAbsolutePath()));
        String arguments = argumentBuf.toString();
        Logger.getLogger("glassfish").log(Level.FINE, "V3 JVM Command: " + startScript + " " + arguments);
        return new NbProcessDescriptor(startScript, arguments);
    }

    private String computeClassPath(Map<String, String> propMap, File domainDir, File bootstrapJar) {
        String result = null;
        List<File> prefixCP = Util.classPathToFileList(propMap.get("classpath-prefix"), domainDir);
        List<File> suffixCP = Util.classPathToFileList(propMap.get("classpath-suffix"), domainDir);
        boolean useEnvCP = "false".equals(propMap.get("env-classpath-ignored"));
        List<File> envCP = Util.classPathToFileList(useEnvCP ? System.getenv("CLASSPATH") : null, domainDir);
        List<File> systemCP = Util.classPathToFileList(propMap.get("system-classpath"), domainDir);
        if (prefixCP.size() > 0 || suffixCP.size() > 0 || envCP.size() > 0 || systemCP.size() > 0) {
            List<File> mainCP = Util.classPathToFileList(bootstrapJar.getAbsolutePath(), null);
            if (mainCP.size() > 0) {
                ArrayList<File> completeCP = new ArrayList<File>(32);
                completeCP.addAll(prefixCP);
                completeCP.addAll(mainCP);
                completeCP.addAll(systemCP);
                completeCP.addAll(envCP);
                completeCP.addAll(suffixCP);
                StringBuilder classPath = new StringBuilder(1024);
                Iterator iter = completeCP.iterator();
                classPath.append(Util.quote(((File)iter.next()).getPath()));
                while (iter.hasNext()) {
                    classPath.append(File.pathSeparatorChar);
                    classPath.append(Util.quote(((File)iter.next()).getPath()));
                }
                result = classPath.toString();
            } else {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to read main classpath from glassfish main jar when building launch classpath.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder appendJavaOpts(List<String> optList, StringBuilder argumentBuf) throws ProcessCreationException {
        block14: {
            String debugPortString = "";
            try {
                for (String option : optList) {
                    argumentBuf.append(' ');
                    argumentBuf.append(option);
                }
                if (!"debugMode".equals(this.ip.get("jvmMode"))) break block14;
                debugPortString = (String)this.ip.get("debugPort");
                String debugTransport = "dt_socket";
                if ("true".equals(this.ip.get("use.shared.mem"))) {
                    debugTransport = "dt_shmem";
                } else {
                    int t = 0;
                    if (null != debugPortString && debugPortString.trim().length() > 0 && ((t = Integer.parseInt(debugPortString)) < 0 || t > 65535)) {
                        throw new NumberFormatException();
                    }
                }
                if (null == debugPortString || "".equals(debugPortString)) {
                    if ("true".equals(this.ip.get("use.shared.mem"))) {
                        debugPortString = Integer.toString(Math.abs(((String)this.ip.get("homefolder") + this.support.getDomainsRoot() + (String)this.ip.get("domainname")).hashCode() + 1));
                    } else {
                        int debugPort = 9009;
                        ServerSocket t = null;
                        try {
                            t = new ServerSocket(0);
                            debugPort = t.getLocalPort();
                            debugPortString = Integer.toString(debugPort);
                        }
                        finally {
                            if (null != t) {
                                t.close();
                            }
                        }
                    }
                }
                this.support.setEnvironmentProperty("debugPort", debugPortString, true);
                argumentBuf.append(" -Xdebug -Xrunjdwp:transport=");
                argumentBuf.append(debugTransport);
                argumentBuf.append(",address=");
                argumentBuf.append(debugPortString);
                argumentBuf.append(",server=y,suspend=n");
            }
            catch (NumberFormatException nfe) {
                throw new ProcessCreationException(nfe, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, debugPortString);
            }
            catch (IOException ioe) {
                throw new ProcessCreationException(ioe, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, debugPortString);
            }
        }
        return argumentBuf;
    }

    private StringBuilder appendSystemVars(Map<String, String> argMap, StringBuilder argumentBuf) {
        this.appendSystemVar(argumentBuf, "jruby.home", (String)this.ip.get("jruby.home"));
        this.appendSystemVar(argumentBuf, "v3.grizzly.cometSupport", (String)this.ip.get("v3.grizzly.cometSupport"));
        if ("true".equals(this.ip.get("useIDEProxyOn"))) {
            String[] PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
            boolean isWindows = Utilities.isWindows();
            for (String prop : PROXY_PROPS) {
                String value = System.getProperty(prop);
                if (value == null || value.trim().length() <= 0) continue;
                if (isWindows && "http.nonProxyHosts".equals(prop)) {
                    value = "\"" + value + "\"";
                }
                argMap.put(prop, value);
            }
        }
        argMap.remove("jruby.home");
        argMap.remove("v3.grizzly.cometSupport");
        for (Map.Entry<String, String> entry : argMap.entrySet()) {
            this.appendSystemVar(argumentBuf, entry.getKey(), entry.getValue());
        }
        return argumentBuf;
    }

    private StringBuilder appendSystemVar(StringBuilder argumentBuf, String key, String value) {
        if (value != null && value.length() > 0) {
            argumentBuf.append(" -D");
            argumentBuf.append(key);
            argumentBuf.append("=");
            argumentBuf.append(Util.quote(value));
        }
        return argumentBuf;
    }

    private Process createProcess() throws ProcessCreationException {
        Process process = null;
        NbProcessDescriptor pd = this.createProcessDescriptor();
        if (pd != null) {
            try {
                process = pd.exec(null, this.createEnvironment(), true, this.getDomainFolder());
            }
            catch (IOException ex) {
                throw new ProcessCreationException(ex, "MSG_START_SERVER_FAILED_PD", this.instanceName);
            }
        }
        return process;
    }

    private File getDomainFolder() {
        return new File(this.support.getDomainsRoot() + File.separatorChar + this.getDomainName());
    }

    private final String getDomainName() {
        return (String)this.ip.get("domainname");
    }

    private boolean readJvmArgs(File domainRoot, List<String> optList, Map<String, String> argMap, Map<String, String> propMap) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("com.sun.aas.installRoot", Utils.escapePath((String)this.ip.get("homefolder")));
        varMap.put("com.sun.aas.instanceRoot", Utils.escapePath(domainRoot.getAbsolutePath()));
        varMap.put("com.sun.aas.javaRoot", Utils.escapePath(this.jdkHome.getPath()));
        varMap.put("com.sun.aas.derbyRoot", this.getJavaDBLocation());
        File domainXml = new File(domainRoot, "config/domain.xml");
        if (domainXml.exists()) {
            JvmConfigReader reader = new JvmConfigReader(optList, argMap, varMap, propMap);
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path("/domain/servers/server", reader.getServerFinder()));
            pathList.add(new TreeParser.Path("/domain/configs/config", reader.getConfigFinder()));
            pathList.add(new TreeParser.Path("/domain/configs/config/java-config", reader));
            File irf = new File((String)this.ip.get("homefolder"));
            File btrace = new File(irf, "lib/monitor/btrace-agent.jar");
            if (btrace.exists()) {
                pathList.add(new TreeParser.Path("/domain/configs/config/monitoring-service", reader.getMonitoringFinder(btrace)));
            }
            try {
                TreeParser.readXml(domainXml, pathList);
                return true;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return false;
    }

    private String getJavaDBLocation() {
        String javadb = (String)this.ip.get("installfolder") + File.separatorChar + "javadb";
        javadb = new File(javadb).exists() ? Utils.escapePath(javadb) : Utils.escapePath(this.jdkHome.getPath() + File.separatorChar + "javadb");
        return javadb;
    }
}

