/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.JFFIInvoker;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.VariadicInvoker;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Factory
extends org.jruby.ext.ffi.Factory {
    public Factory() {
        if (!Platform.getPlatform().isSupported()) {
            throw new UnsatisfiedLinkError("JFFI backend not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                JFFIInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                VariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Callback") == null) {
                CallbackManager.createCallbackClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Function") == null) {
                Function.createFunctionClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("LastError") == null) {
                ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
            }
        }
    }

    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocate(runtime2, size2, clear2);
    }

    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime2, int size2, int align, boolean clear2) {
        return AllocatedNativeMemoryIO.allocateAligned(runtime2, size2, align, clear2);
    }

    public DirectMemoryIO wrapDirectMemory(Ruby runtime2, long address2) {
        return NativeMemoryIO.wrap(runtime2, address2);
    }

    public Function newFunction(Ruby runtime2, Pointer address2, CallbackInfo cbInfo) {
        CodeMemoryIO mem = new CodeMemoryIO(runtime2, address2);
        RubyClass klass = runtime2.fastGetModule("FFI").fastGetClass("Function");
        return new Function(runtime2, klass, mem, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, null);
    }

    public CallbackManager getCallbackManager() {
        return CallbackManager.getInstance();
    }

    private static final Type getType(NativeType type2) {
        Type jffiType = FFIUtil.getFFIType(type2);
        if (jffiType == null) {
            throw new UnsupportedOperationException("Cannot determine native type for " + type2);
        }
        return jffiType;
    }

    public int sizeOf(NativeType type2) {
        return Factory.getType(type2).size();
    }

    public int alignmentOf(NativeType type2) {
        return Factory.getType(type2).alignment();
    }

    public static final class LastError {
        @JRubyMethod(name={"error"}, meta=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.getRuntime().newFixnum(com.kenai.jffi.LastError.getInstance().get());
        }
    }
}

