/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;

public class GlobalProfilingPointsProcessor
implements DataManagerListener {
    private static GlobalProfilingPointsProcessor defaultInstance;
    private List<TimedGlobalProfilingPoint> scheduledTimedPPs = new LinkedList<TimedGlobalProfilingPoint>();
    private List<TriggeredGlobalProfilingPoint> scheduledTriggeredPPs = new LinkedList<TriggeredGlobalProfilingPoint>();
    private ProfilingSettings profilingSettings;
    private Project profiledProject;
    private GlobalProfilingPoint[] gpp;
    private boolean isRunning = false;
    private long currentHeapSize;
    private long currentHeapUsage;
    private long currentLoadedClasses;
    private long currentSurvGen;
    private long currentTime = System.currentTimeMillis();

    public void dataChanged() {
        this.processTelemetryEvent();
    }

    public void dataReset() {
        this.processTelemetryEvent();
    }

    static synchronized GlobalProfilingPointsProcessor getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new GlobalProfilingPointsProcessor();
        }
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyProfilingStateChanged() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            boolean bl = ProfilingPointsManager.getDefault().isProfilingInProgress();
            boolean bl2 = ProfilingPointsManager.getDefault().isProfilingSessionInProgress();
            if (bl2 && !bl) {
                if (this.isRunning) {
                    this.stop();
                }
                this.init();
            } else if (bl) {
                if (!this.isRunning) {
                    this.start();
                }
            } else {
                this.stop();
            }
        }
    }

    private boolean anyProfilingPointsScheduled() {
        return this.scheduledTimedPPs.size() > 0 || this.scheduledTriggeredPPs.size() > 0;
    }

    private void checkForStop() {
        if (!this.anyProfilingPointsScheduled()) {
            this.stop();
        }
    }

    private void init() {
        this.profiledProject = NetBeansProfiler.getDefaultNB().getProfiledProject();
        this.profilingSettings = NetBeansProfiler.getDefaultNB().getLastProfilingSettings();
        if (this.profiledProject != null && this.profilingSettings.useProfilingPoints()) {
            for (GlobalProfilingPoint globalProfilingPoint : this.gpp = ProfilingPointsManager.getDefault().createGlobalProfilingConfiguration(this.profiledProject, this.profilingSettings)) {
                this.scheduleProfilingPoint(globalProfilingPoint);
            }
        }
    }

    private void initListeners() {
        NetBeansProfiler.getDefaultNB().getVMTelemetryManager().addDataListener((DataManagerListener)this);
    }

    private void processTelemetryEvent() {
        MonitoredData monitoredData = NetBeansProfiler.getDefaultNB().getVMTelemetryManager().getLastData();
        if (monitoredData != null) {
            this.processTimeEvent();
            long l = NetBeansProfiler.getDefaultNB().getVMTelemetryManager().maxHeapSize;
            this.currentHeapSize = monitoredData.getTotalMemory();
            long l2 = this.currentHeapSize - monitoredData.getFreeMemory();
            this.currentHeapUsage = Math.round((double)l2 / (double)l * 100.0);
            this.currentSurvGen = monitoredData.getNSurvivingGenerations();
            this.currentLoadedClasses = monitoredData.getLoadedClassesCount();
            this.processTriggeredProfilingPoints();
        }
    }

    private void processTimeEvent() {
        this.currentTime = System.currentTimeMillis();
        this.processTimedProfilingPoints();
    }

    private void processTimedProfilingPoint(TimedGlobalProfilingPoint timedGlobalProfilingPoint, List<TimedGlobalProfilingPoint> list) {
        timedGlobalProfilingPoint.hit(this.currentTime);
        this.scheduleTimedProfilingPoint(timedGlobalProfilingPoint, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedProfilingPoints() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            this.checkForStop();
            if (this.isRunning) {
                LinkedList<TimedGlobalProfilingPoint> linkedList = new LinkedList<TimedGlobalProfilingPoint>();
                for (TimedGlobalProfilingPoint timedGlobalProfilingPoint : this.scheduledTimedPPs) {
                    if (this.timeConditionMet(timedGlobalProfilingPoint.getCondition())) {
                        this.processTimedProfilingPoint(timedGlobalProfilingPoint, linkedList);
                        continue;
                    }
                    linkedList.add(timedGlobalProfilingPoint);
                }
                this.scheduledTimedPPs.clear();
                this.scheduledTimedPPs.addAll(linkedList);
            }
        }
    }

    private void processTriggeredProfilingPoint(TriggeredGlobalProfilingPoint triggeredGlobalProfilingPoint, List<TriggeredGlobalProfilingPoint> list) {
        TriggeredGlobalProfilingPoint.TriggerCondition triggerCondition = triggeredGlobalProfilingPoint.getCondition();
        if (!triggerCondition.isTriggered()) {
            triggerCondition.setTriggered(true);
            long l = -1L;
            if (triggerCondition.getMetric() == 2) {
                l = this.currentHeapSize;
            } else if (triggerCondition.getMetric() == 1) {
                l = this.currentHeapUsage;
            } else if (triggerCondition.getMetric() == 3) {
                l = this.currentSurvGen;
            } else if (triggerCondition.getMetric() == 4) {
                l = this.currentLoadedClasses;
            }
            triggeredGlobalProfilingPoint.hit(l);
        } else {
            triggerCondition.setTriggered(false);
        }
        if (!triggerCondition.isOnetime()) {
            this.scheduleTriggeredProfilingPoint(triggeredGlobalProfilingPoint, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTriggeredProfilingPoints() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            this.checkForStop();
            if (this.isRunning) {
                LinkedList<TriggeredGlobalProfilingPoint> linkedList = new LinkedList<TriggeredGlobalProfilingPoint>();
                for (TriggeredGlobalProfilingPoint triggeredGlobalProfilingPoint : this.scheduledTriggeredPPs) {
                    if (this.triggerConditionMet(triggeredGlobalProfilingPoint.getCondition())) {
                        this.processTriggeredProfilingPoint(triggeredGlobalProfilingPoint, linkedList);
                        continue;
                    }
                    linkedList.add(triggeredGlobalProfilingPoint);
                }
                this.scheduledTriggeredPPs.clear();
                this.scheduledTriggeredPPs.addAll(linkedList);
            }
        }
    }

    private void reset() {
        this.gpp = null;
        this.profiledProject = null;
        this.profilingSettings = null;
        this.scheduledTimedPPs.clear();
        this.scheduledTriggeredPPs.clear();
    }

    private void resetListeners() {
        NetBeansProfiler.getDefaultNB().getVMTelemetryManager().removeDataListener((DataManagerListener)this);
    }

    private void scheduleProfilingPoint(GlobalProfilingPoint globalProfilingPoint) {
        if (globalProfilingPoint instanceof TimedGlobalProfilingPoint) {
            this.scheduleTimedProfilingPoint((TimedGlobalProfilingPoint)globalProfilingPoint, this.scheduledTimedPPs);
        } else if (globalProfilingPoint instanceof TriggeredGlobalProfilingPoint) {
            this.scheduleTriggeredProfilingPoint((TriggeredGlobalProfilingPoint)globalProfilingPoint, this.scheduledTriggeredPPs);
        }
    }

    private void scheduleTimedProfilingPoint(TimedGlobalProfilingPoint timedGlobalProfilingPoint, List<TimedGlobalProfilingPoint> list) {
        TimedGlobalProfilingPoint.TimeCondition timeCondition = timedGlobalProfilingPoint.getCondition();
        long l = System.currentTimeMillis();
        long l2 = timeCondition.getScheduledTime();
        boolean bl = timeCondition.getRepeats();
        long l3 = timeCondition.getPeriodTime();
        switch (timeCondition.getPeriodUnits()) {
            case 1: {
                l3 *= 60000L;
                break;
            }
            case 2: {
                l3 *= 3600000L;
                break;
            }
        }
        if (l2 < l) {
            if (!bl) {
                return;
            }
            long l4 = (long)Math.ceil((double)(l - l2) / (double)l3);
            l2 += l4 * l3;
        }
        if (l2 >= l) {
            timeCondition.setScheduledTime(l2);
            list.add(timedGlobalProfilingPoint);
        }
    }

    private void scheduleTriggeredProfilingPoint(TriggeredGlobalProfilingPoint triggeredGlobalProfilingPoint, List<TriggeredGlobalProfilingPoint> list) {
        list.add(triggeredGlobalProfilingPoint);
    }

    private void start() {
        if (this.profiledProject == null || this.gpp == null || this.gpp.length == 0 || !this.anyProfilingPointsScheduled()) {
            this.reset();
            return;
        }
        this.isRunning = true;
        this.initListeners();
    }

    private void stop() {
        this.isRunning = false;
        this.resetListeners();
        this.reset();
    }

    private boolean timeConditionMet(TimedGlobalProfilingPoint.TimeCondition timeCondition) {
        return timeCondition.getScheduledTime() <= this.currentTime;
    }

    private boolean triggerConditionMet(TriggeredGlobalProfilingPoint.TriggerCondition triggerCondition) {
        if (triggerCondition.getMetric() == 2) {
            return triggerCondition.isTriggered() ? triggerCondition.getValue() >= this.currentHeapSize : triggerCondition.getValue() < this.currentHeapSize;
        }
        if (triggerCondition.getMetric() == 1) {
            return triggerCondition.isTriggered() ? triggerCondition.getValue() >= this.currentHeapUsage : triggerCondition.getValue() < this.currentHeapUsage;
        }
        if (triggerCondition.getMetric() == 3) {
            return triggerCondition.isTriggered() ? triggerCondition.getValue() >= this.currentSurvGen : triggerCondition.getValue() < this.currentSurvGen;
        }
        if (triggerCondition.getMetric() == 4) {
            return triggerCondition.isTriggered() ? triggerCondition.getValue() >= this.currentLoadedClasses : triggerCondition.getValue() < this.currentLoadedClasses;
        }
        return false;
    }
}

