/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.Utilities;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(JTextComponent textComponent, boolean skipEOL) throws BadLocationException {
        int offset = textComponent.getCaretPosition();
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)textComponent, (int)offset, (boolean)true, (boolean)false);
        if (ts != null) {
            Token token = ts.token();
            String category = ((CppTokenId)token.id()).primaryCategory();
            if ("identifier".equals(category) || "preprocessor-user-include-literal".equals(category) || "preprocessor-system-include-literal".equals(category)) {
                CharSequence image = token.text();
                if (image != null && image.length() > 0) {
                    char charAtI;
                    int i;
                    int length = image.length();
                    int offsetInImage = offset - ts.offset();
                    int start = offsetInImage + 1;
                    if (Character.isUpperCase(image.charAt(offsetInImage))) {
                        for (i = start; i < length && Character.isUpperCase(charAtI = image.charAt(i)); ++i) {
                            ++start;
                        }
                    }
                    for (i = start; i < length; ++i) {
                        charAtI = image.charAt(i);
                        if (!Character.isUpperCase(charAtI)) continue;
                        return ts.offset() + i;
                    }
                    return ts.offset() + length;
                }
            } else if ("whitespace".equals(((CppTokenId)token.id()).primaryCategory())) {
                int endWS;
                do {
                    endWS = ts.offset() + ts.token().length();
                } while ((skipEOL || ts.token().id() != CppTokenId.NEW_LINE) && ts.moveNext() && "whitespace".equals(((CppTokenId)ts.token().id()).primaryCategory()));
                return endWS;
            }
        }
        return Utilities.getNextWord((JTextComponent)textComponent, (int)offset);
    }

    static int previousCamelCasePosition(JTextComponent textComponent) throws BadLocationException {
        int offset = textComponent.getCaretPosition();
        if (offset == 0) {
            return 0;
        }
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)textComponent, (int)offset, (boolean)true, (boolean)true);
        if (ts != null) {
            Token token = ts.token();
            String category = ((CppTokenId)token.id()).primaryCategory();
            if ("identifier".equals(category) || "preprocessor-user-include-literal".equals(category) || "preprocessor-system-include-literal".equals(category)) {
                CharSequence image = token.text();
                if (image != null && image.length() > 0) {
                    int upperCaseOffset;
                    int offsetInImage = offset - 1 - ts.offset();
                    for (upperCaseOffset = offsetInImage - 1; upperCaseOffset > 0 && !Character.isUpperCase(image.charAt(upperCaseOffset)); --upperCaseOffset) {
                    }
                    if (upperCaseOffset > 0 && Character.isUpperCase(image.charAt(upperCaseOffset))) {
                        for (int i = upperCaseOffset - 1; i >= 0; --i) {
                            char charAtI = image.charAt(i);
                            if (Character.isUpperCase(charAtI)) continue;
                            return ts.offset() + i + 1;
                        }
                    }
                    return ts.offset();
                }
            } else if ("whitespace".equals(((CppTokenId)token.id()).primaryCategory())) {
                int wsOffset = ts.offset();
                while (ts.movePrevious() && "whitespace".equals(((CppTokenId)ts.token().id()).primaryCategory())) {
                    wsOffset = ts.offset();
                    if (wsOffset != 0) continue;
                    return 0;
                }
                return wsOffset;
            }
        }
        return Utilities.getPreviousWord((JTextComponent)textComponent, (int)offset);
    }
}

