/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.spellchecker.bindings.java.JavaTokenListProvider;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSemanticTokenList
implements TokenList {
    private List<Position[]> identifiers;
    private Document doc;
    private int currentIndex;
    private ChangeSupport pcs = new ChangeSupport((Object)this);
    private static Map<FileObject, JavaSemanticTokenList> js2TokenList = new WeakHashMap<FileObject, JavaSemanticTokenList>();

    public synchronized void set(List<Position[]> list, Document document) {
        this.identifiers = list;
        this.doc = document;
        this.pcs.fireChange();
    }

    public synchronized void setStartOffset(int n) {
        if (this.identifiers == null) {
            return;
        }
        this.currentIndex = 0;
        while (this.currentIndex < this.identifiers.size() && this.identifiers.get(this.currentIndex)[0].getOffset() <= n) {
            ++this.currentIndex;
        }
        if (this.currentIndex < this.identifiers.size()) {
            --this.currentIndex;
        }
    }

    public synchronized boolean nextWord() {
        if (this.identifiers == null) {
            return false;
        }
        return ++this.currentIndex < this.identifiers.size();
    }

    public synchronized int getCurrentWordStartOffset() {
        int n = this.identifiers.get(this.currentIndex)[0].getOffset();
        return n;
    }

    public synchronized CharSequence getCurrentWordText() {
        try {
            String string = this.doc.getText(this.identifiers.get(this.currentIndex)[0].getOffset(), this.identifiers.get(this.currentIndex)[1].getOffset() - this.identifiers.get(this.currentIndex)[0].getOffset());
            return string;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return "";
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.pcs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.pcs.removeChangeListener(changeListener);
    }

    static synchronized JavaSemanticTokenList get(FileObject fileObject) {
        if (!JavaTokenListProvider.ENABLE_SEMANTIC_TOKEN_LIST) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return null;
        }
        JavaSemanticTokenList javaSemanticTokenList = js2TokenList.get(fileObject);
        if (javaSemanticTokenList == null) {
            javaSemanticTokenList = new JavaSemanticTokenList();
            js2TokenList.put(fileObject, javaSemanticTokenList);
        }
        return javaSemanticTokenList;
    }

    static List<String> separateWords(String string, List<int[]> list) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (char c : string.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!bl && n2 - n > 0) {
                    linkedList.add(string.substring(n, n2));
                    list.add(new int[]{n, n2});
                    n = n2;
                }
                bl = true;
            } else {
                bl = false;
            }
            ++n2;
        }
        if (n2 - n > 0) {
            linkedList.add(string.substring(n, n2));
            list.add(new int[]{n, n2});
        }
        return linkedList;
    }

    static void handleIdentifier(Document document, List<Position[]> list, int[] nArray, String string) {
        if (nArray == null) {
            return;
        }
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        List<String> list2 = JavaSemanticTokenList.separateWords(string, linkedList);
        for (int[] nArray2 : linkedList) {
            try {
                list.add(new Position[]{document.createPosition(nArray[0] + nArray2[0]), document.createPosition(nArray[0] + nArray2[1])});
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory {
        public FactoryImpl() {
            super(JavaSource.Phase.PARSED, JavaSource.Priority.LOW);
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new TaskImpl();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TaskImpl
    implements CancellableTask<CompilationInfo> {
        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            JavaSemanticTokenList javaSemanticTokenList = JavaSemanticTokenList.get(compilationInfo.getFileObject());
            if (javaSemanticTokenList == null) {
                return;
            }
            Document document = compilationInfo.getDocument();
            if (document == null) {
                return;
            }
            ScannerImpl scannerImpl = new ScannerImpl(document, compilationInfo);
            ArrayList<Position[]> arrayList = new ArrayList<Position[]>();
            scannerImpl.scan(compilationInfo.getCompilationUnit(), arrayList);
            javaSemanticTokenList.set(arrayList, compilationInfo.getDocument());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ScannerImpl
        extends TreeScanner<Void, List<Position[]>> {
            private Document doc;
            private CompilationInfo info;

            public ScannerImpl(Document document, CompilationInfo compilationInfo) {
                this.doc = document;
                this.info = compilationInfo;
            }

            @Override
            public Void visitClass(ClassTree classTree, List<Position[]> list) {
                int[] nArray = this.info.getTreeUtilities().findNameSpan(classTree);
                JavaSemanticTokenList.handleIdentifier(this.doc, list, nArray, classTree.getSimpleName().toString());
                return (Void)super.visitClass(classTree, list);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, List<Position[]> list) {
                int[] nArray = this.info.getTreeUtilities().findNameSpan(methodTree);
                JavaSemanticTokenList.handleIdentifier(this.doc, list, nArray, methodTree.getName().toString());
                return (Void)super.visitMethod(methodTree, list);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, List<Position[]> list) {
                int[] nArray = this.info.getTreeUtilities().findNameSpan(variableTree);
                JavaSemanticTokenList.handleIdentifier(this.doc, list, nArray, variableTree.getName().toString());
                return (Void)super.visitVariable(variableTree, list);
            }
        }
    }
}

