/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.jrefmask.PersistentState;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JrefOutputFormatter
extends OutputFormatter {
    PersistentState ps;
    Vector<ZipEntry> zipEntries;
    Vector<byte[]> dataVector = new Vector();

    public JrefOutputFormatter(BufferedReader bufferedReader) throws IOException {
        super(bufferedReader);
        this.zipEntries = new Vector();
        this.ps = new PersistentState(this.getProperties());
    }

    @Override
    public void format(RomMask romMask) {
        this.ps.formatPS(romMask);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)outputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.ps.write(dataOutputStream);
        this.createZipEntry(byteArrayOutputStream.toByteArray(), "Persistent.data", false);
        for (int i = 0; i < this.zipEntries.size(); ++i) {
            zipOutputStream.putNextEntry(this.zipEntries.elementAt(i));
            byte[] byArray = this.dataVector.elementAt(i);
            zipOutputStream.write(byArray, 0, byArray.length);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
    }

    public void createZipEntry(byte[] byArray, String string, boolean bl) {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setMethod(0);
        zipEntry.setSize(byArray.length);
        zipEntry.setTime(System.currentTimeMillis());
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        zipEntry.setCrc(cRC32.getValue());
        if (bl) {
            this.zipEntries.add(zipEntry);
            this.dataVector.add(byArray);
        } else {
            this.zipEntries.insertElementAt(zipEntry, 0);
            this.dataVector.insertElementAt(byArray, 0);
        }
    }

    public void writeDebugInfo(Vector<File> vector) {
        try {
            for (File file : vector) {
                this.mergeDebugLocations(file, this.ps.maskSymbols.getTable());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
            System.exit(1);
        }
        catch (IOException iOException) {
            Msg.error("jref.1", null);
            System.exit(1);
        }
    }

    private void mergeDebugLocations(File file, Map<String, String> map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        String string = this.mergeDebugComponent(dataInputStream, dataOutputStream, map);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.createZipEntry(byArray, string + "/javacard/debug.cap", true);
    }

    private String mergeDebugComponent(DataInputStream dataInputStream, DataOutputStream dataOutputStream, Map<String, String> map) throws IOException {
        int n;
        dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = dataInputStream.readUTF();
            dataOutputStream.writeUTF(stringArray[n]);
        }
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        int n4 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n4);
        for (n = 0; n < n4; ++n) {
            this.mergeClassDebugInfo(dataInputStream, dataOutputStream, stringArray, map);
        }
        return stringArray[n3];
    }

    private void mergeClassDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, String> map) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        dataInputStream.readUnsignedShort();
        String string = stringArray[n2];
        String string2 = map.get("CLASS:" + string);
        int n3 = Integer.parseInt(string2, 16);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n4 = dataInputStream.readUnsignedByte();
        dataOutputStream.writeByte(n4);
        int n5 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n5);
        int n6 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n6);
        for (n = 0; n < n4; ++n) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
        for (n = 0; n < n5; ++n) {
            this.mergeFieldDebugInfo(dataInputStream, dataOutputStream, stringArray, map, string);
        }
        for (n = 0; n < n6; ++n) {
            this.mergeMethodDebugInfo(dataInputStream, dataOutputStream, stringArray, map, string);
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, String> map, String string) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        int n4 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n4);
        boolean bl = (n4 & 0x400) != 0;
        dataInputStream.readUnsignedShort();
        if (bl) {
            dataOutputStream.writeShort(0);
        } else {
            String string2 = stringArray[n2];
            String string3 = stringArray[n3];
            String string4 = string + "/" + string2 + string3;
            String string5 = map.get("METHOD:" + string4);
            n = Integer.parseInt(string5, 16);
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n5 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n5);
        int n6 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n6);
        for (n = 0; n < n5; ++n) {
            dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
        for (n = 0; n < n6; ++n) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
    }

    private void mergeFieldDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, String> map, String string) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n);
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        boolean bl = (n3 & 8) != 0;
        boolean bl2 = (n3 & 0x10) != 0;
        boolean bl3 = stringArray[n2].length() == 1;
        if (bl & !(bl2 & bl3)) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataInputStream.readUnsignedShort();
            String string2 = string + "/" + stringArray[n];
            String string3 = map.get("FIELD:" + string2);
            int n4 = Integer.parseInt(string3, 16);
            dataOutputStream.writeShort(n4);
        } else {
            dataOutputStream.writeInt(dataInputStream.readInt());
        }
    }
}

