/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsServiceCreator
implements ServiceCreator {
    private static final String SOAP_BINDING_TYPE = "javax.xml.ws.soap.SOAPBinding";
    private static final String BINDING_TYPE_ANNOTATION = "javax.xml.ws.BindingType";
    private static final String SOAP12_HTTP_BINDING = "SOAP12HTTP_BINDING";
    private Project project;
    private WizardDescriptor wiz;
    private boolean addJaxWsLib;
    private int serviceType;

    public JaxWsServiceCreator(Project project, WizardDescriptor wizardDescriptor, boolean bl) {
        this.project = project;
        this.wiz = wizardDescriptor;
        this.addJaxWsLib = bl;
    }

    public void createService() throws IOException {
        this.serviceType = (Integer)this.wiz.getProperty("webServiceType");
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        progressHandle.start(100);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JaxWsServiceCreator.this.generateWebService(progressHandle);
                }
                catch (IOException iOException) {
                    progressHandle.finish();
                    String string = iOException.getLocalizedMessage();
                    if (string != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    public void createServiceFromWsdl() throws IOException {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    progressHandle.start(100);
                    JaxWsServiceCreator.this.generateWsFromWsdl15(progressHandle);
                }
                catch (IOException iOException) {
                    progressHandle.finish();
                    String string = iOException.getLocalizedMessage();
                    if (string != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private void generateWebService(ProgressHandle progressHandle) throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        if (this.serviceType == 0) {
            progressHandle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
            if (this.addJaxWsLib) {
                MavenModelUtils.addJaxws21Library(this.project);
            }
            this.generateJaxWSImplFromTemplate(fileObject, WSUtils.isEJB(this.project), false);
            progressHandle.finish();
        } else if (this.serviceType == 1) {
            String string = Templates.getTargetName((WizardDescriptor)this.wiz);
            progressHandle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
            Node[] nodeArray = (Node[])this.wiz.getProperty("delegateToSessionBean");
            this.generateWebServiceFromEJB(string, fileObject, nodeArray);
            progressHandle.finish();
        }
    }

    private void generateWsFromWsdl15(ProgressHandle progressHandle) throws IOException {
        progressHandle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
        String string = (String)this.wiz.getProperty("wsdl_url");
        String string2 = (String)this.wiz.getProperty("wsdlFilePath");
        if (string == null) {
            string = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string2))).getURL().toExternalForm();
        }
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(true);
        boolean bl = false;
        File file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src");
        bl = file.exists() ? true : file.mkdirs();
        if (fileObject != null) {
            Object object;
            String string3;
            FileObject fileObject2 = null;
            try {
                fileObject2 = WSUtils.retrieveResource(fileObject, bl ? new URI("src/jax-ws-catalog.xml") : new URI("jax-ws-catalog.xml"), new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_IncorrectURI", (Object)string);
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            catch (UnknownHostException unknownHostException) {
                string3 = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_UnknownHost", (Object)unknownHostException.getMessage());
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            catch (IOException iOException) {
                string3 = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)string);
                object = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
            }
            if (fileObject2 != null) {
                final boolean bl2 = MavenModelUtils.isJaxWs21Library(this.project);
                string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                object = fileObject2.getName();
                Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenWebService.class, (boolean)true);
                if (preferences != null) {
                    preferences.put("_S_" + WSUtils.getUniqueId(fileObject2.getName(), jAXWSLightSupport.getServices()), string);
                }
                ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>((String)object, string3){
                    final /* synthetic */ String val$serviceName;
                    final /* synthetic */ String val$relativePath;
                    {
                        this.val$serviceName = string;
                        this.val$relativePath = string2;
                    }

                    public void performOperation(POMModel pOMModel) {
                        if (!bl2) {
                            try {
                                MavenModelUtils.addJaxws21Library(JaxWsServiceCreator.this.project, pOMModel);
                                MavenModelUtils.addJavadoc(JaxWsServiceCreator.this.project);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(JaxWsServiceCreator.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", exception);
                            }
                        }
                        Plugin plugin = WSUtils.isEJB(JaxWsServiceCreator.this.project) ? MavenModelUtils.addJaxWSPlugin(pOMModel, "2.0") : MavenModelUtils.addJaxWSPlugin(pOMModel);
                        MavenModelUtils.addWsimportExecution(plugin, this.val$serviceName, this.val$relativePath);
                        if (WSUtils.isWeb(JaxWsServiceCreator.this.project)) {
                            MavenModelUtils.addWarPlugin(pOMModel);
                        } else {
                            MavenModelUtils.addWsdlResources(pOMModel);
                        }
                    }
                };
                Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(modelOperation));
                FileObject fileObject3 = Templates.getTargetFolder((WizardDescriptor)this.wiz);
                FileObject fileObject4 = this.generateJaxWSImplFromTemplate(fileObject3, false, true);
                RunConfig runConfig = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"JAX-WS:wsimport", Collections.singletonList("org.codehaus.mojo:jaxws-maven-plugin:wsimport"));
                ExecutorTask executorTask = RunUtils.executeMaven((RunConfig)runConfig);
                try {
                    executorTask.waitFinished(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                WsdlService wsdlService = (WsdlService)this.wiz.getProperty("wsdlService");
                WsdlPort wsdlPort = (WsdlPort)this.wiz.getProperty("wsdlPort");
                try {
                    SaveCookie saveCookie;
                    String string4 = WSUtils.isWeb(this.project) ? "WEB-INF/wsdl/" : "META-INF/wsdl/";
                    this.generateJaxWsImplClass(fileObject4, wsdlService, wsdlPort, string4 + string3);
                    DataObject dataObject = DataObject.find((FileObject)fileObject4);
                    if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                        saveCookie.save();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
        }
        progressHandle.finish();
    }

    private FileObject generateJaxWSImplFromTemplate(FileObject fileObject, boolean bl, boolean bl2) throws IOException {
        DataObject dataObject;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (!bl2 && ((Boolean)this.wiz.getProperty("endpointAsStatelessBean")).booleanValue()) {
            dataObject = fileObject2.getParent();
            fileObject2 = dataObject.getFileObject("EjbWebService", "java");
        }
        dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wiz));
        FileObject fileObject3 = dataObject2.getPrimaryFile();
        JaxWsServiceCreator.openFileInEditor(dataObject2);
        return fileObject3;
    }

    private ClassPath getClassPathForFile(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        }
        return null;
    }

    public static void openFileInEditor(DataObject dataObject) {
        final OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    openCookie.open();
                }
            }, 1000);
        }
    }

    private void generateJaxWsImplClass(FileObject fileObject, final WsdlService wsdlService, final WsdlPort wsdlPort, final String string) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (classTree != null) {
                    Object object;
                    MemberSelectTree memberSelectTree;
                    Object object2;
                    Object object3;
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.jws.WebService");
                    ArrayList<AssignmentTree> arrayList = new ArrayList<AssignmentTree>();
                    arrayList.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"serviceName"), (ExpressionTree)treeMaker.Literal((Object)wsdlService.getName())));
                    arrayList.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"portName"), (ExpressionTree)treeMaker.Literal((Object)wsdlPort.getName())));
                    arrayList.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"endpointInterface"), (ExpressionTree)treeMaker.Literal((Object)wsdlPort.getJavaName())));
                    arrayList.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)treeMaker.Literal((Object)wsdlPort.getNamespaceURI())));
                    arrayList.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)treeMaker.Literal((Object)string)));
                    AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), arrayList);
                    ClassTree classTree2 = generationUtils.addAnnotation(classTree, annotationTree);
                    if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(wsdlPort.getSOAPVersion()) && (object3 = workingCopy.getElements().getTypeElement(JaxWsServiceCreator.BINDING_TYPE_ANNOTATION)) != null) {
                        object2 = workingCopy.getElements().getTypeElement(JaxWsServiceCreator.SOAP_BINDING_TYPE);
                        memberSelectTree = treeMaker.MemberSelect(treeMaker.QualIdent((Element)object2), (CharSequence)JaxWsServiceCreator.SOAP12_HTTP_BINDING);
                        object = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object3), Collections.singletonList(memberSelectTree));
                        classTree2 = generationUtils.addAnnotation(classTree2, (AnnotationTree)object);
                    }
                    if (WSUtils.isEJB(JaxWsServiceCreator.this.project) && (object3 = workingCopy.getElements().getTypeElement("javax.ejb.Stateless")) != null) {
                        object2 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object3), Collections.emptyList());
                        classTree2 = generationUtils.addAnnotation(classTree2, (AnnotationTree)object2);
                    }
                    object3 = wsdlPort.getOperations();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        Object object4;
                        Object object5;
                        Object object62;
                        memberSelectTree = (WsdlOperation)object2.next();
                        object = memberSelectTree.getReturnTypeName();
                        List list = memberSelectTree.getParameters();
                        ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
                        for (Object object62 : list) {
                            arrayList2.add(treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)object62.getName(), (Tree)treeMaker.Identifier((CharSequence)object62.getTypeName()), null));
                        }
                        Iterator iterator = memberSelectTree.getExceptions();
                        object62 = new ArrayList();
                        while (iterator.hasNext()) {
                            object5 = (String)iterator.next();
                            object4 = workingCopy.getElements().getTypeElement((CharSequence)object5);
                            if (object4 != null) {
                                object62.add(treeMaker.QualIdent((Element)object4));
                                continue;
                            }
                            object62.add(treeMaker.Identifier((CharSequence)object5));
                        }
                        object5 = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                        object4 = treeMaker.Method((ModifiersTree)object5, (CharSequence)memberSelectTree.getJavaName(), (Tree)treeMaker.Identifier((CharSequence)object), Collections.emptyList(), arrayList2, (List)object62, "{ //TODO implement this method\nthrow new UnsupportedOperationException(\"Not implemented yet.\") }", null);
                        classTree2 = treeMaker.addClassMember(classTree2, (Tree)object4);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
    }

    private void generateWebServiceFromEJB(String string, FileObject fileObject, Node[] nodeArray) throws IOException {
        EjbReference ejbReference;
        if (nodeArray != null && nodeArray.length == 1 && (ejbReference = (EjbReference)nodeArray[0].getLookup().lookup(EjbReference.class)) != null) {
            DataObject dataObject;
            FileObject fileObject2;
            ClassPath classPath;
            FileObject fileObject3;
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            FileObject fileObject4 = Templates.getTemplate((WizardDescriptor)this.wiz);
            if (((Boolean)this.wiz.getProperty("endpointAsStatelessBean")).booleanValue()) {
                fileObject3 = fileObject4.getParent();
                fileObject4 = fileObject3.getFileObject("EjbWebService", "java");
            }
            if ((classPath = this.getClassPathForFile(this.project, fileObject2 = (dataObject = (fileObject3 = DataObject.find((FileObject)fileObject4)).createFromTemplate(dataFolder, string)).getPrimaryFile())) != null) {
                ContainerClassPathModifier containerClassPathModifier;
                if (classPath.findResource("javax/ejb/EJB.class") == null && (containerClassPathModifier = (ContainerClassPathModifier)this.project.getLookup().lookup(ContainerClassPathModifier.class)) != null) {
                    containerClassPathModifier.extendClasspath(fileObject2, new String[]{"ejb"});
                }
                this.generateDelegateMethods(fileObject2, ejbReference);
                JaxWsServiceCreator.openFileInEditor(dataObject);
            }
        }
    }

    private void generateDelegateMethods(final FileObject fileObject, final EjbReference ejbReference) throws IOException {
        final boolean[] blArray = new boolean[1];
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                if (typeElement != null) {
                    VariableTree variableTree = null;
                    stringArray[0] = ejbReference.getLocal();
                    if (stringArray[0] == null) {
                        stringArray[0] = ejbReference.getRemote();
                    }
                    if (stringArray[0] == null) {
                        stringArray[0] = ejbReference.getEjbClass();
                    }
                    if ((variableTree = JaxWsServiceCreator.this.generateEjbInjection(workingCopy, treeMaker, stringArray[0], blArray)) != null) {
                        String string = "Add business logic below. (Right-click in editor and choose";
                        String string2 = "\"Web Service > Add Operation\"";
                        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)string), false);
                        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)string2), false);
                        ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                        ClassTree classTree2 = treeMaker.insertClassMember(classTree, 0, (Tree)variableTree);
                        if (blArray[0]) {
                            TypeElement typeElement2 = workingCopy.getElements().getTypeElement(stringArray[0]);
                            classTree2 = JaxWsServiceCreator.this.generateMethods(workingCopy, treeMaker, typeElement, classTree2, typeElement2);
                        }
                        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                    }
                }
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
        if (!blArray[0]) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_EJB_NOT_ON_CLASSPATH", (Object)stringArray[0], (Object)fileObject.getName()), 2));
                }
            });
        }
    }

    private VariableTree generateEjbInjection(WorkingCopy workingCopy, TreeMaker treeMaker, String string, boolean[] blArray) {
        TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.ejb.EJB");
        TypeElement typeElement2 = workingCopy.getElements().getTypeElement(string);
        AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), Collections.emptyList());
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(annotationTree));
        blArray[0] = typeElement2 != null;
        return treeMaker.Variable(modifiersTree, (CharSequence)"ejbRef", blArray[0] ? treeMaker.Type(typeElement2.asType()) : treeMaker.Identifier((CharSequence)string), null);
    }

    private ClassTree generateMethods(WorkingCopy workingCopy, TreeMaker treeMaker, TypeElement typeElement, ClassTree classTree, TypeElement typeElement2) throws IOException {
        GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
        List<? extends Element> list = typeElement2.getEnclosedElements();
        TypeElement typeElement3 = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
        assert (typeElement3 != null);
        if (typeElement3 == null) {
            return classTree;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element : list) {
            Tree tree;
            Object object;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            MethodTree methodTree = generatorUtilities.createAbstractMethodImplementation(typeElement, executableElement);
            Name name = executableElement.getSimpleName();
            boolean bl = workingCopy.getTypes().getNoType(TypeKind.VOID) == executableElement.getReturnType();
            String string = this.findUniqueOperationName(hashSet, name.toString());
            hashSet.add(string);
            AssignmentTree assignmentTree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"operationName"), (ExpressionTree)treeMaker.Literal((Object)string));
            AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement3), Collections.singletonList(assignmentTree));
            ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(annotationTree));
            if (!name.contentEquals(string)) {
                object6 = workingCopy.getElements().getTypeElement("javax.xml.ws.RequestWrapper");
                object5 = workingCopy.getElements().getTypeElement("javax.xml.ws.ResponseWrapper");
                object4 = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"className"), (ExpressionTree)treeMaker.Literal((Object)string));
                object3 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object6), Collections.singletonList(object4));
                modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, (AnnotationTree)object3);
                if (!bl) {
                    object4 = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"className"), (ExpressionTree)treeMaker.Literal((Object)(string + "Response")));
                    AnnotationTree annotationTree2 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object5), Collections.singletonList(object4));
                    modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, annotationTree2);
                }
            }
            if (bl && methodTree.getThrows().isEmpty()) {
                object6 = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                object5 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object6), Collections.emptyList());
                modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, (AnnotationTree)object5);
            }
            object6 = methodTree.getParameters();
            object5 = new ArrayList();
            if (object6.size() > 0) {
                object4 = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                object3 = object6.iterator();
                while (object3.hasNext()) {
                    VariableTree variableTree = (VariableTree)object3.next();
                    object = variableTree.getName().toString();
                    tree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"name"), (ExpressionTree)treeMaker.Literal(object));
                    AnnotationTree annotationTree3 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)object4), Collections.singletonList(tree));
                    ModifiersTree modifiersTree2 = treeMaker.addModifiersAnnotation(variableTree.getModifiers(), annotationTree3);
                    object5.add(treeMaker.Variable(modifiersTree2, (CharSequence)variableTree.getName(), variableTree.getType(), null));
                }
            }
            object4 = new ArrayList();
            for (VariableElement variableElement : executableElement.getParameters()) {
                object4.add(treeMaker.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            object3 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"ejbRef"), (CharSequence)name), (List)object4);
            StatementTree object22 = bl ? treeMaker.ExpressionStatement((ExpressionTree)object3) : treeMaker.Return((ExpressionTree)object3);
            object = treeMaker.Block(Collections.singletonList(object22), false);
            tree = treeMaker.Method(modifiersTree, (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), (List)object5, methodTree.getThrows(), (BlockTree)object, null);
            classTree = treeMaker.addClassMember(classTree, tree);
        }
        return classTree;
    }

    private String findUniqueOperationName(Set<String> set, String string) {
        if (!set.contains(string)) {
            return string;
        }
        int n = 1;
        String string2 = string + "_1";
        while (set.contains(string2)) {
            string2 = string + "_" + String.valueOf(++n);
        }
        return string2;
    }
}

