/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;

public class CompletionUtilities {
    private CompletionUtilities() {
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(Document doc, int offset, FileReferencesContext fileReferncesContext) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file == null || !file.isValid()) {
            return Collections.emptyList();
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, fileReferncesContext);
        return CsmContextUtilities.findFunctionLocalVariables(context);
    }

    public static List<CsmField> findClassFields(Document doc, int offset) {
        CsmClass clazz = CompletionUtilities.findClassOnPosition(doc, offset);
        List<CsmField> res = null;
        if (clazz != null) {
            res = new CsmProjectContentResolver().getFields(clazz, false);
        }
        return res;
    }

    public static List<CsmDeclaration> findFileVariables(Document doc, int offset) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file == null || !file.isValid()) {
            return Collections.emptyList();
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, null);
        return CsmContextUtilities.findFileLocalVariables(context);
    }

    public static CsmClass findClassOnPosition(Document doc, int offset) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file == null || !file.isValid()) {
            return null;
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, null);
        CsmClass clazz = CsmContextUtilities.getClass(context, true, false);
        return clazz;
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(Document doc, int offset) {
        return CompletionUtilities.findFunDefinitionOrClassOnPosition(doc, offset, null);
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(Document doc, int offset, FileReferencesContext fileReferncesContext) {
        CsmContext context;
        CsmFunctionDefinition out = null;
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (!(file == null || (out = CsmContextUtilities.getFunctionDefinition(context = CsmOffsetResolver.findContext(file, offset, fileReferncesContext))) != null && CsmContextUtilities.isInFunctionBodyOrInitializerList(context, offset))) {
            out = CsmContextUtilities.getClass(context, false, false);
        }
        return out;
    }

    public static Collection<CsmObject> findItemsReferencedAtCaretPos(JTextComponent target, Document doc, CsmCompletionQuery query, int dotPos) {
        List<CsmObject> out = new ArrayList<CsmObject>();
        try {
            BaseDocument baseDoc = null;
            if (doc instanceof BaseDocument) {
                baseDoc = (BaseDocument)doc;
            }
            baseDoc = baseDoc != null ? baseDoc : (BaseDocument)target.getDocument();
            boolean searchFunctionsOnly = false;
            boolean searchSpecializationsOnly = false;
            int[] idBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)baseDoc, (int)dotPos);
            boolean bl = idBlk != null ? idBlk.length == 3 : (searchFunctionsOnly = false);
            if (idBlk == null || idBlk.length == 2) {
                idBlk = CompletionUtilities.getIdentifierAndInstantiationBlock(baseDoc, dotPos);
                boolean bl2 = idBlk != null ? idBlk.length == 3 : (searchSpecializationsOnly = false);
            }
            if (idBlk == null) {
                idBlk = new int[]{dotPos, dotPos};
            }
            CsmFile currentFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            for (int ind = idBlk.length - 1; ind >= 1; --ind) {
                CsmCompletionQuery.CsmCompletionResult resultx;
                int endOfMethod;
                CsmCompletionQuery.CsmCompletionResult result = query.query(target, baseDoc, idBlk[ind], true, false, false);
                if (result == null || result.getItems().isEmpty()) continue;
                List<CsmObject> filtered = CompletionUtilities.getAssociatedObjects(result.getItems(), searchFunctionsOnly, currentFile);
                List<CsmObject> list = out = !filtered.isEmpty() ? filtered : CompletionUtilities.getAssociatedObjects(result.getItems(), false, currentFile);
                if (filtered.size() > 1 && searchFunctionsOnly && (endOfMethod = CompletionUtilities.findEndOfMethod((Document)baseDoc, idBlk[ind] - 1)) > -1 && (resultx = query.query(target, baseDoc, endOfMethod, true, false, false)) != null && !resultx.getItems().isEmpty()) {
                    out = CompletionUtilities.getAssociatedObjects(resultx.getItems(), false, currentFile);
                }
                if (filtered.size() > 1 && searchSpecializationsOnly && (endOfMethod = CompletionUtilities.findEndOfInstantiation((Document)baseDoc, idBlk[ind] - 1)) > -1 && (resultx = query.query(target, baseDoc, endOfMethod, true, false, false)) != null && !resultx.getItems().isEmpty()) {
                    out = CompletionUtilities.getAssociatedObjects(resultx.getItems(), false, currentFile);
                }
                break;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return out;
    }

    private static int[] getIdentifierAndInstantiationBlock(BaseDocument doc, int offset) throws BadLocationException {
        int[] instBlk;
        int[] idBlk = Utilities.getIdentifierBlock((BaseDocument)doc, (int)offset);
        if (idBlk != null && (instBlk = CompletionUtilities.getInstantiationBlock(doc, idBlk)) != null) {
            return new int[]{idBlk[0], idBlk[1], instBlk[1]};
        }
        return idBlk;
    }

    private static int[] getInstantiationBlock(BaseDocument doc, int[] identifierBlock) throws BadLocationException {
        int nwPos;
        if (identifierBlock != null && (nwPos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)identifierBlock[1])) >= 0 && doc.getChars(nwPos, 1)[0] == '<') {
            return new int[]{identifierBlock[0], nwPos + 1};
        }
        return null;
    }

    private static List<CsmObject> getAssociatedObjects(List items, boolean wantFuncsOnly, CsmFile contextFile) {
        ArrayList<CsmObject> visible = new ArrayList<CsmObject>();
        ArrayList<CsmObject> all = new ArrayList<CsmObject>();
        ArrayList<CsmObject> funcs = new ArrayList<CsmObject>();
        ArrayList<CsmObject> visibleFuncs = new ArrayList<CsmObject>();
        for (Object item : items) {
            if (!(item instanceof CsmResultItem)) continue;
            CsmObject ret = CompletionUtilities.getAssociatedObject(item);
            boolean isVisible = contextFile == null ? false : CsmIncludeResolver.getDefault().isObjectVisible(contextFile, ret);
            boolean isFunc = CsmKindUtilities.isFunction((CsmObject)ret);
            if (isFunc) {
                if (isVisible) {
                    visibleFuncs.add(ret);
                } else {
                    funcs.add(ret);
                }
            }
            if (isVisible) {
                visible.add(ret);
                continue;
            }
            all.add(ret);
        }
        ArrayList<CsmObject> out = wantFuncsOnly ? (!visibleFuncs.isEmpty() ? visibleFuncs : funcs) : (!visible.isEmpty() ? visible : all);
        return out;
    }

    private static CsmObject getAssociatedObject(Object item) {
        CsmObject ret;
        if (item instanceof CsmResultItem && (ret = (CsmObject)((CsmResultItem)item).getAssociatedObject()) != null) {
            return ret;
        }
        return null;
    }

    public static int findEndOfMethod(Document doc, int startPos) {
        int level = 0;
        CharSequence text = DocumentUtilities.getText((Document)doc);
        for (int i = startPos; i < doc.getLength(); ++i) {
            char ch = text.charAt(i);
            if (ch == ';') {
                return -1;
            }
            if (ch == '(') {
                ++level;
            }
            if (ch != ')' || --level != 0) continue;
            return i + 1;
        }
        return -1;
    }

    public static int findEndOfInstantiation(Document doc, int startPos) {
        int level = 0;
        CharSequence text = DocumentUtilities.getText((Document)doc);
        for (int i = startPos; i < doc.getLength(); ++i) {
            char ch = text.charAt(i);
            if (ch == ';') {
                return -1;
            }
            if (ch == '<') {
                ++level;
            }
            if (ch != '>' || --level != 0) continue;
            return i + 1;
        }
        return -1;
    }
}

