/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.injector;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.injector.ScreenInjectorPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenBooleanInjectorPresenter
extends ScreenInjectorPresenter {
    private String propertyName;
    private String displayName;
    private int order;

    public ScreenBooleanInjectorPresenter(String string, String string2, int n) {
        assert (string != null && string2 != null);
        this.propertyName = string;
        this.displayName = string2;
        this.order = n;
    }

    public boolean isEnabled() {
        return true;
    }

    public JComponent getViewComponent() {
        InjectorCheckBox injectorCheckBox = new InjectorCheckBox(this.displayName);
        PropertyValue propertyValue = this.getComponent().readProperty(this.propertyName);
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            injectorCheckBox.setSelected(MidpTypes.getBoolean(propertyValue));
        } else {
            injectorCheckBox.setEnabled(false);
        }
        return injectorCheckBox;
    }

    public Integer getOrder() {
        return this.order;
    }

    private class InjectorCheckBox
    extends JCheckBox
    implements ActionListener {
        public InjectorCheckBox(String string) {
            super(string);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final DesignComponent designComponent = ScreenBooleanInjectorPresenter.this.getComponent();
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    designComponent.writeProperty(ScreenBooleanInjectorPresenter.this.propertyName, MidpTypes.createBooleanValue(InjectorCheckBox.this.isSelected()));
                }
            });
            PopupUtil.hidePopup();
        }
    }
}

