/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener,
HelpCtx.Provider {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_MAIN_NAME = "mainName";
    private PanelConfigureProject panel;
    private String templateName;
    private String name;
    private boolean makefileNameChanged = false;
    private int type;
    private volatile boolean initialized = false;
    private static final Object FAKE_ITEM = new Object();
    private JButton browseButton;
    private JCheckBox createMainCheckBox;
    private JComboBox createMainComboBox;
    private JTextField createMainTextField;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JLabel makefileLabel;
    private JTextField makefileTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JCheckBox setAsMainCheckBox;
    private JComboBox toolchainComboBox;
    private JLabel toolchainLabel;
    private static ResourceBundle bundle;

    public PanelProjectLocationVisual(PanelConfigureProject panel, String name, boolean showMakefileTextField, int type) {
        this.initComponents();
        this.panel = panel;
        this.name = name;
        this.templateName = name;
        this.type = type;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        if (showMakefileTextField) {
            this.makefileTextField.getDocument().addDocumentListener(this);
            this.makefileTextField.getDocument().addDocumentListener(new MakefileDocumentListener());
        } else {
            this.makefileTextField.setVisible(false);
            this.makefileLabel.setVisible(false);
        }
        this.makefileTextField.getAccessibleContext().setAccessibleDescription(PanelProjectLocationVisual.getString("AD_MAKEFILE"));
        this.setAsMainCheckBox.setVisible(true);
        this.createMainTextField.setText("main");
        this.createMainTextField.getDocument().addDocumentListener(this);
        if (type == 1) {
            this.createMainCheckBox.setVisible(true);
            this.createMainTextField.setVisible(true);
            this.createMainComboBox.setVisible(true);
            this.createMainComboBox.addItem("C");
            this.createMainComboBox.addItem("C++");
            String prefLanguage = MakeOptions.getInstance().getPrefApplicationLanguage();
            this.createMainComboBox.setSelectedItem(prefLanguage);
        } else if (type == 4) {
            this.createMainCheckBox.setVisible(true);
            this.createMainTextField.setVisible(true);
            this.createMainComboBox.setVisible(true);
            this.createMainComboBox.addItem("C++");
            this.createMainComboBox.setSelectedIndex(0);
        } else {
            this.createMainCheckBox.setVisible(false);
            this.createMainTextField.setVisible(false);
            this.createMainComboBox.setVisible(false);
        }
        PanelProjectLocationVisual.disableHostsInfo(this.hostComboBox, this.toolchainComboBox);
    }

    static void disableHostsInfo(JComboBox hostComboBox, JComboBox toolchainComboBox) {
        hostComboBox.setEnabled(false);
        toolchainComboBox.setEnabled(false);
        hostComboBox.addItem(FAKE_ITEM);
        toolchainComboBox.addItem(FAKE_ITEM);
        hostComboBox.setRenderer(new MyDevHostListCellRenderer(FAKE_ITEM));
        toolchainComboBox.setRenderer(new MyToolchainListCellRenderer(FAKE_ITEM));
    }

    static void updateToolchainsComponents(JComboBox hostComboBox, JComboBox toolchainComboBox, Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enabled) {
        hostComboBox.removeAllItems();
        toolchainComboBox.removeAllItems();
        if (records != null) {
            for (ServerRecord serverRecord : records) {
                hostComboBox.addItem(serverRecord);
            }
            hostComboBox.setSelectedItem(srToSelect);
            PanelProjectLocationVisual.updateToolchains(toolchainComboBox, srToSelect);
            toolchainComboBox.setSelectedItem(csToSelect);
            hostComboBox.setEnabled(enabled);
            toolchainComboBox.setEnabled(enabled);
        }
    }

    private static Collection<ServerRecord> initServerRecords() {
        ArrayList<ServerRecord> out = new ArrayList<ServerRecord>();
        for (ServerRecord serverRecord : ServerList.getRecords()) {
            CompilerSetManager csm;
            if (!serverRecord.isSetUp() || serverRecord.isDeleted() || (csm = CompilerSetManager.get((ExecutionEnvironment)serverRecord.getExecutionEnvironment())) == null) continue;
            csm.finishInitialization();
            if (csm.isEmpty() || csm.isUninitialized()) continue;
            out.add(serverRecord);
        }
        return out;
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewAppWizard");
    }

    public CompilerSet getProjectCompilerSet() {
        return (CompilerSet)this.toolchainComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.makefileLabel = new JLabel();
        this.makefileTextField = new JTextField();
        this.createMainCheckBox = new JCheckBox();
        this.createMainTextField = new JTextField();
        this.createMainComboBox = new JComboBox();
        this.setAsMainCheckBox = new JCheckBox();
        this.hostLabel = new JLabel();
        this.toolchainLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.toolchainComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.projectNameLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectNameLabel"));
        this.projectNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectLocationLabel"));
        this.projectLocationTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_browseButton"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_createdFolderLabel"));
        this.createdFolderTextField.setColumns(20);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.makefileLabel.setLabelFor(this.makefileTextField);
        Mnemonics.setLocalizedText((JLabel)this.makefileLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_MAKEFILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.makefileLabel, gridBagConstraints);
        this.makefileTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.makefileTextField, gridBagConstraints);
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)bundle.getString("LBL_createMainfile"));
        this.createMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.createMainCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.createMainCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.createMainCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.createMainTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.createMainComboBox, gridBagConstraints);
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)bundle.getString("LBL_setAsMainCheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.setAsMainCheckBox, gridBagConstraints);
        this.hostLabel.setLabelFor(this.hostComboBox);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.toolchainLabel.setLabelFor(this.toolchainComboBox);
        Mnemonics.setLocalizedText((JLabel)this.toolchainLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_TOOLCHAIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.toolchainLabel, gridBagConstraints);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelProjectLocationVisual.this.hostComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.toolchainComboBox, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocationTextField.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    private void createMainCheckBoxActionPerformed(ActionEvent evt) {
        this.createMainTextField.setEnabled(this.createMainCheckBox.isSelected());
        this.createMainComboBox.setEnabled(this.createMainCheckBox.isSelected());
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initialized) {
            return;
        }
        if (evt.getStateChange() == 1) {
            ServerRecord newItem = (ServerRecord)evt.getItem();
            PanelProjectLocationVisual.updateToolchains(this.toolchainComboBox, newItem);
            this.panel.fireChangeEvent();
        }
    }

    static void updateToolchains(JComboBox toolchainComboBox, ServerRecord newItem) {
        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)newItem.getExecutionEnvironment());
        toolchainComboBox.removeAllItems();
        for (CompilerSet compilerSet : csm.getCompilerSets()) {
            toolchainComboBox.addItem(compilerSet);
        }
        toolchainComboBox.setSelectedItem(csm.getDefaultCompilerSet());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    private boolean isValidMakeFile(String text) {
        if (text.length() == 0) {
            return false;
        }
        return !text.contains("\\") && !text.contains("/") && !text.contains("..") && !this.hasIllegalChar(text);
    }

    private boolean isValidMainFile(String text) {
        if (text.length() == 0) {
            return true;
        }
        return !text.startsWith(" ") && !text.startsWith("\\") && !text.startsWith("/") && !text.contains("..") && !this.hasIllegalChar(text);
    }

    private boolean isValidProjectName(String text) {
        if (text.length() == 0 || text.startsWith(" ") || text.contains("\\") || text.contains("/") || this.hasIllegalChar(text)) {
            return false;
        }
        boolean ok = false;
        try {
            File file = File.createTempFile(text + "dummy", "");
            ok = true;
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    private boolean hasIllegalChar(String text) {
        return text.contains(":") || text.contains("*") || text.contains("?") || text.contains("\"") || text.contains("<") || text.contains(">") || text.contains("|");
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        ServerRecord sr;
        File projLoc;
        if (!this.initialized) {
            return false;
        }
        if (!this.isValidProjectName(this.projectNameTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File f = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(f) == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File destFolder = PanelProjectLocationVisual.getCanonicalFile(new File(this.createdFolderTextField.getText()).getAbsoluteFile());
        if (destFolder == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        if (this.makefileTextField.getText().indexOf(" ") >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_SpacesInMakefile"));
            return false;
        }
        if (!this.isValidMakeFile(this.makefileTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalMakefileName"));
            return false;
        }
        if (this.createMainCheckBox.isSelected() && !this.isValidMainFile(this.createMainTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalMainFileName"));
            return false;
        }
        for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (destFolder.exists()) {
            if (destFolder.isFile()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_NotAFolder", (Object)this.makefileTextField.getText()));
                return false;
            }
            if (new File(destFolder.getPath(), this.makefileTextField.getText()).exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_MakefileExists", (Object)this.makefileTextField.getText()));
                return false;
            }
            if (new File(destFolder.getPath(), "nbproject").exists() || new File(destFolder.getPath(), "build").exists() || new File(destFolder.getPath(), "dist").exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
                return false;
            }
        }
        if ((sr = (ServerRecord)this.hostComboBox.getSelectedItem()) == null || !sr.isOnline()) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_OfflineHost"));
        }
        return true;
    }

    @Override
    void store(WizardDescriptor d) {
        Object obj;
        String projectName = this.projectNameTextField.getText().trim();
        String location = this.projectLocationTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)projectName);
        d.putProperty("makefilename", (Object)this.makefileTextField.getText());
        File projectsDir = new File(this.projectLocationTextField.getText());
        if (projectsDir.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)projectsDir);
        }
        d.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() && this.setAsMainCheckBox.isVisible() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("mainClass", null);
        MIMEExtensions cExtensions = MIMEExtensions.get((String)"text/x-c");
        MIMEExtensions ccExtensions = MIMEExtensions.get((String)"text/x-c++");
        d.putProperty("createMainFile", (Object)(this.createMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        if (this.createMainCheckBox.isSelected() && this.createMainTextField.getText().length() > 0) {
            if (this.type == 1) {
                if (((String)this.createMainComboBox.getSelectedItem()).equals("C")) {
                    d.putProperty("mainFileName", (Object)(this.createMainTextField.getText() + "." + cExtensions.getDefaultExtension()));
                    d.putProperty("mainFileTemplate", (Object)"Templates/cFiles/main.c");
                } else {
                    d.putProperty("mainFileName", (Object)(this.createMainTextField.getText() + "." + ccExtensions.getDefaultExtension()));
                    d.putProperty("mainFileTemplate", (Object)"Templates/cppFiles/main.cc");
                }
                MakeOptions.getInstance().setPrefApplicationLanguage((String)this.createMainComboBox.getSelectedItem());
            } else if (this.type == 4) {
                d.putProperty("mainFileName", (Object)(this.createMainTextField.getText() + "." + ccExtensions.getDefaultExtension()));
                d.putProperty("mainFileTemplate", (Object)"Templates/qtFiles/main.cc");
            }
        }
        if ((obj = this.hostComboBox.getSelectedItem()) != null && obj instanceof ServerRecord) {
            ServerRecord sr = (ServerRecord)obj;
            d.putProperty("hostUID", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)sr.getExecutionEnvironment()));
        }
        d.putProperty("toolchain", this.toolchainComboBox.getSelectedItem());
    }

    @Override
    void read(WizardDescriptor settings) {
        this.initialized = false;
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String hostUID = (String)settings.getProperty("hostUID");
        CompilerSet cs = (CompilerSet)settings.getProperty("toolchain");
        Boolean readOnlyToolchain = (Boolean)settings.getProperty("readOnlyToolchain");
        RequestProcessor.getDefault().post((Runnable)new DevHostsInitializer(hostUID, cs, readOnlyToolchain){

            @Override
            public void updateComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enabled) {
                PanelProjectLocationVisual.updateToolchainsComponents(PanelProjectLocationVisual.this.hostComboBox, PanelProjectLocationVisual.this.toolchainComboBox, records, srToSelect, csToSelect, enabled);
                PanelProjectLocationVisual.this.initialized = true;
                PanelProjectLocationVisual.this.panel.fireChangeEvent();
            }
        });
        String projectName = (String)settings.getProperty("displayName");
        if (projectName == null) {
            String workingDir = (String)settings.getProperty("buildCommandWorkingDirTextField");
            if (workingDir != null && workingDir.length() > 0 && this.templateName.equals("MakefileProject")) {
                this.name = CndPathUtilitities.getBaseName((String)workingDir);
            }
            int baseCount = 1;
            String formater = this.name + "_{0}";
            while ((projectName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
            settings.putProperty("nameIndex", (Object)baseCount);
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String projectName = MessageFormat.format(formater, index);
        File file = new File(parentFolder, projectName);
        return file.exists() ? null : projectName;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.createMainTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_MAIN_NAME, null, this.createMainTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.createMainTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_MAIN_NAME, null, this.createMainTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.createMainTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_MAIN_NAME, null, this.createMainTextField.getText());
        }
    }

    private String contructProjectMakefileName(int count) {
        String makefileName = this.projectNameTextField.getText() + "-" + "Makefile";
        makefileName = count > 0 ? makefileName + "" + count + ".mk" : makefileName + ".mk";
        return makefileName;
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText().trim();
            String projectFolder = this.projectLocationTextField.getText().trim();
            while (projectFolder.endsWith("/")) {
                projectFolder = projectFolder.substring(0, projectFolder.length() - 1);
            }
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
            if (!this.makefileNameChanged) {
                String proposedMakefile;
                String makefileName = !this.templateName.equals("MakefileProject") ? "Makefile" : this.contructProjectMakefileName(0);
                int count = 0;
                while (new File(proposedMakefile = this.createdFolderTextField.getText() + File.separatorChar + makefileName).exists() || new File(proposedMakefile.toLowerCase()).exists() || new File(proposedMakefile.toUpperCase()).exists()) {
                    makefileName = this.contructProjectMakefileName(count++);
                }
                this.makefileTextField.setText(makefileName);
                this.makefileNameChanged = false;
            }
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PanelProjectLocationVisual.class);
        }
        return bundle.getString(s);
    }

    static abstract class DevHostsInitializer
    implements Runnable {
        private final String hostUID;
        private final CompilerSet cs;
        private final boolean readOnlyUI;
        private Collection<ServerRecord> records;
        private ServerRecord srToSelect;
        private CompilerSet csToSelect;

        public DevHostsInitializer(String hostUID, CompilerSet cs, Boolean readOnlyToolchain) {
            this.hostUID = hostUID;
            this.cs = cs;
            this.readOnlyUI = readOnlyToolchain == null ? false : readOnlyToolchain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    ExecutionEnvironment ee;
                    this.records = PanelProjectLocationVisual.initServerRecords();
                    this.srToSelect = null;
                    if (this.hostUID != null && (ee = ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID)) != null) {
                        this.srToSelect = ServerList.get((ExecutionEnvironment)ee);
                    }
                    if (!this.records.contains(this.srToSelect)) {
                        this.srToSelect = null;
                    }
                    if (this.srToSelect == null || this.srToSelect.isDeleted()) {
                        this.srToSelect = ServerList.getDefaultRecord();
                    }
                    if (this.cs == null) {
                        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)this.srToSelect.getExecutionEnvironment());
                        this.csToSelect = csm.getDefaultCompilerSet();
                    }
                    this.csToSelect = this.cs;
                }
                finally {
                    SwingUtilities.invokeLater(this);
                }
            } else {
                this.updateComponents(this.records, this.srToSelect, this.csToSelect, !this.readOnlyUI);
            }
        }

        public abstract void updateComponents(Collection<ServerRecord> var1, ServerRecord var2, CompilerSet var3, boolean var4);
    }

    static final class MyToolchainListCellRenderer
    extends DefaultListCellRenderer {
        private final Object loadingMarker;

        public MyToolchainListCellRenderer(Object loadingItem) {
            this.loadingMarker = loadingItem;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.loadingMarker.equals(value)) {
                label.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Loading_Toolchain_Text"));
            } else {
                CompilerSet cs = (CompilerSet)value;
                if (cs != null) {
                    label.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Toolchain_Name_Text", (Object)cs.getName(), (Object)cs.getDisplayName()));
                }
            }
            return label;
        }
    }

    static final class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        private final Object loadingMarker;

        public MyDevHostListCellRenderer(Object loadingItem) {
            this.loadingMarker = loadingItem;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.loadingMarker.equals(value)) {
                label.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Loading_Host_Text"));
            } else {
                ServerRecord rec = (ServerRecord)value;
                if (rec != null) {
                    label.setText(rec.getDisplayName());
                }
            }
            return label;
        }
    }

    class MakefileDocumentListener
    implements DocumentListener {
        MakefileDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelProjectLocationVisual.this.makefileNameChanged = true;
        }
    }
}

