/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final int OPTION_APPLY = 2;
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    public static final String COMMAND_APPLY = "APPLY";
    private DialogDescriptor dialogDescriptor;
    private Map<Project, Dialog> customizerPerProject = new WeakHashMap<Project, Dialog>();
    private final ConfigurationDescriptorProvider projectDescriptorProvider;
    private String currentCommand;
    private final Map<MakeContext.Kind, String> lastCurrentNodeName = new EnumMap<MakeContext.Kind, String>(MakeContext.Kind.class);
    private final Set<ActionListener> actionListenerList = new HashSet<ActionListener>();

    public MakeCustomizerProvider(Project project, ConfigurationDescriptorProvider projectDescriptorProvider) {
        this.project = project;
        this.projectDescriptorProvider = projectDescriptorProvider;
    }

    public void showCustomizer() {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Project), null, null);
    }

    public void showCustomizer(Item item) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Item), item, null);
    }

    public void showCustomizer(Folder folder) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Folder), null, folder);
    }

    public void showCustomizer(String preselectedNodeName) {
        this.showCustomizer(preselectedNodeName, null, null);
    }

    public void showCustomizer(final String preselectedNodeName, final Item item, final Folder folder) {
        if (!this.projectDescriptorProvider.gotDescriptor() || this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().size() == 0) {
            return;
        }
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MakeCustomizerProvider.this.showCustomizerWorker(preselectedNodeName, item, folder);
            }
        });
    }

    private void showCustomizerWorker(String preselectedNodeName, Item item, Folder folder) {
        Dialog dlg;
        if (this.customizerPerProject.containsKey(this.project) && (dlg = this.customizerPerProject.get(this.project)).isShowing()) {
            dlg.setVisible(true);
            return;
        }
        if (folder != null) {
            Configuration[] configurations = this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                folder.getFolderConfiguration(configurations[i]);
            }
        }
        this.projectDescriptorProvider.getConfigurationDescriptor().refreshRequiredLanguages();
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Customizer_Apply_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Ok_Option"));
        options[1].setActionCommand(COMMAND_CANCEL);
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Cancel_Option"));
        options[2].setActionCommand(COMMAND_APPLY);
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"ACSD_Customizer_Apply_Option"));
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderOk"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderCancel"));
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"AD_MakeCustomizerProviderApply"));
        options[2].setMnemonic(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"MNE_Customizer_Apply_Option").charAt(0));
        ConfigurationDescriptor clonedProjectdescriptor = this.projectDescriptorProvider.getConfigurationDescriptor().cloneProjectDescriptor();
        ArrayList<JButton> controls = new ArrayList<JButton>();
        controls.add(options[0]);
        MakeCustomizer innerPane = new MakeCustomizer(this.project, preselectedNodeName, clonedProjectdescriptor, item, folder, Collections.unmodifiableCollection(controls));
        OptionListener optionsListener = new OptionListener(this.project, this.projectDescriptorProvider.getConfigurationDescriptor(), clonedProjectdescriptor, innerPane, folder, item);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        options[2].addActionListener(optionsListener);
        String dialogTitle = null;
        dialogTitle = item != null ? MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_File_Customizer_Title"), item.getFile().getName()) : (folder != null ? MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Folder_Customizer_Title"), folder.getName()) : MessageFormat.format(NbBundle.getMessage(MakeCustomizerProvider.class, (String)"LBL_Project_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        this.dialogDescriptor = new DialogDescriptor((Object)innerPane, dialogTitle, true, options, (Object)options[0], 0, null, null);
        this.dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        innerPane.setDialogDescriptor(this.dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.customizerPerProject.put(this.project, dialog);
        this.currentCommand = COMMAND_CANCEL;
        dialog.setVisible(true);
        MakeContext lastContext = innerPane.getLastContext();
        String nodeName = innerPane.getCurrentNodeName();
        if (lastContext != null) {
            this.lastCurrentNodeName.put(lastContext.getKind(), nodeName);
        }
        if (this.currentCommand.equals(COMMAND_CANCEL)) {
            this.fireActionEvent(new ActionEvent(this.project, 0, this.currentCommand));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent e) {
        Iterator<ActionListener> it;
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            it = new HashSet<ActionListener>(this.actionListenerList).iterator();
        }
        while (it.hasNext()) {
            it.next().actionPerformed(e);
        }
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeCustomizerProvider.class).getString(s);
    }

    private final class OptionListener
    implements ActionListener {
        private Project project;
        private ConfigurationDescriptor projectDescriptor;
        private ConfigurationDescriptor clonedProjectdescriptor;
        private MakeCustomizer makeCustomizer;
        private Folder folder;
        private Item item;

        OptionListener(Project project, ConfigurationDescriptor projectDescriptor, ConfigurationDescriptor clonedProjectdescriptor, MakeCustomizer makeCustomizer, Folder folder, Item item) {
            this.project = project;
            this.projectDescriptor = projectDescriptor;
            this.clonedProjectdescriptor = clonedProjectdescriptor;
            this.makeCustomizer = makeCustomizer;
            this.folder = folder;
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MakeCustomizerProvider.this.currentCommand = e.getActionCommand();
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_OK) || MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                int currentVersion;
                int previousVersion = this.projectDescriptor.getVersion();
                if (previousVersion < (currentVersion = 69)) {
                    String txt = MakeCustomizerProvider.getString("UPGRADE_TXT");
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)txt, MakeCustomizerProvider.getString("UPGRADE_DIALOG_TITLE"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    this.projectDescriptor.setVersion(currentVersion);
                }
                this.makeCustomizer.save();
                List<String> oldSourceRoots = ((MakeConfigurationDescriptor)this.projectDescriptor).getSourceRoots();
                List<String> newSourceRoots = ((MakeConfigurationDescriptor)this.clonedProjectdescriptor).getSourceRoots();
                List<String> oldTestRoots = ((MakeConfigurationDescriptor)this.projectDescriptor).getTestRoots();
                List<String> newTestRoots = ((MakeConfigurationDescriptor)this.clonedProjectdescriptor).getTestRoots();
                Configuration oldActive = this.projectDescriptor.getConfs().getActive();
                Configuration newActive = this.clonedProjectdescriptor.getConfs().getActive();
                this.projectDescriptor.assign(this.clonedProjectdescriptor);
                this.projectDescriptor.setModified();
                this.projectDescriptor.save();
                MakeSharabilityQuery query = (MakeSharabilityQuery)this.project.getLookup().lookup(MakeSharabilityQuery.class);
                if (query != null) {
                    query.update();
                }
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedItems(this.project, this.folder, this.item);
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedSourceRoots(oldSourceRoots, newSourceRoots);
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedTestRoots(oldTestRoots, newTestRoots);
                ((MakeConfigurationDescriptor)this.projectDescriptor).checkConfigurations(oldActive, newActive);
            }
            if (MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_APPLY)) {
                this.makeCustomizer.refresh();
            }
            if (!MakeCustomizerProvider.this.currentCommand.equals(MakeCustomizerProvider.COMMAND_CANCEL)) {
                MakeCustomizerProvider.this.fireActionEvent(new ActionEvent(this.project, 0, MakeCustomizerProvider.this.currentCommand));
            }
        }
    }
}

