/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitmodelext.addressing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;

public enum Addressing13WsdlQName {
    ADDRESSING(Addressing13WsdlQName.createAddressingQName("Addressing")),
    ANONYMOUSRESPONSES(Addressing13WsdlQName.createAddressingQName("AnonymousResponses"));

    private static final String A_NS_PREFIX = "wsam";
    static final String A_NS_URI = "http://www.w3.org/2007/05/addressing/metadata";
    static final String A_NS_URI_EXT = "http://www.w3.org/2007/05/addressing/metadata/ws-addr-metadata.xsd";
    static final String A_NS_URI_LOCAL = "nbres:/org/netbeans/modules/websvc/wsitmodelext/catalog/resources/ws-addr-metadata.xsd";
    private final QName qName;

    static QName createAddressingQName(String localName) {
        return new QName(A_NS_URI, localName, A_NS_PREFIX);
    }

    private Addressing13WsdlQName(QName name) {
        this.qName = name;
    }

    public QName getQName(ConfigVersion cfgVersion) {
        return new QName(Addressing13WsdlQName.getNamespaceUri(cfgVersion), this.qName.getLocalPart(), this.qName.getPrefix());
    }

    public static String getNamespaceUri(ConfigVersion cfgVersion) {
        switch (cfgVersion) {
            case CONFIG_2_0: {
                return A_NS_URI;
            }
            case CONFIG_1_3: {
                return A_NS_URI;
            }
            case CONFIG_1_0: {
                throw new IllegalArgumentException("These ADDR assertions are supported for 1.3 only!");
            }
        }
        return null;
    }

    public static ConfigVersion getConfigVersion(QName q) {
        for (ConfigVersion cfgVersion : ConfigVersion.values()) {
            if (!Addressing13WsdlQName.getQNames(cfgVersion).contains(q)) continue;
            return cfgVersion;
        }
        System.err.println("Not found config version for: " + q);
        return null;
    }

    public static Set<QName> getQNames(ConfigVersion cfgVersion) {
        HashSet<QName> qnames = new HashSet<QName>();
        for (Addressing13WsdlQName wq : Addressing13WsdlQName.values()) {
            qnames.add(wq.getQName(cfgVersion));
        }
        return qnames;
    }

    public Map<String, String> getSchemaLocations(boolean local) {
        HashMap<String, String> hmap = new HashMap<String, String>();
        for (ConfigVersion cfg : ConfigVersion.values()) {
            try {
                String nsUri = Addressing13WsdlQName.getNamespaceUri(cfg);
                hmap.put(nsUri, this.getSchemaLocation(nsUri, local));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return hmap;
    }

    public String getSchemaLocation(String namespace, boolean local) {
        if (A_NS_URI.equals(namespace)) {
            return local ? A_NS_URI_LOCAL : A_NS_URI_EXT;
        }
        return null;
    }
}

