/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class LazyTypeCompletionItem
extends JavaCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> handle;
    private EnumSet<ElementKind> kinds;
    private Source source;
    private boolean insideNew;
    private boolean addTypeVars;
    private boolean afterExtends;
    private String name;
    private String simpleName;
    private String pkgName;
    private JavaCompletionItem delegate = null;
    private CharSequence sortText;
    private int prefWidth = -1;

    public static final LazyTypeCompletionItem create(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, Source source, boolean bl, boolean bl2, boolean bl3) {
        return new LazyTypeCompletionItem(elementHandle, enumSet, n, source, bl, bl2, bl3);
    }

    private LazyTypeCompletionItem(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, Source source, boolean bl, boolean bl2, boolean bl3) {
        super(n);
        this.handle = elementHandle;
        this.kinds = enumSet;
        this.source = source;
        this.insideNew = bl;
        this.addTypeVars = bl2;
        this.afterExtends = bl3;
        this.name = elementHandle.getQualifiedName();
        int n2 = this.name.lastIndexOf(46);
        this.simpleName = n2 > -1 ? this.name.substring(n2 + 1) : this.name;
        this.pkgName = n2 > -1 ? this.name.substring(0, n2) : "";
        this.sortText = this.simpleName + Utilities.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
    }

    public boolean accept() {
        if (this.handle != null) {
            try {
                ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(LazyTypeCompletionItem.this.substitutionOffset));
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Scope scope = compilationController.getTrees().getScope(compilationController.getTreeUtilities().pathFor(LazyTypeCompletionItem.this.substitutionOffset));
                        TypeElement typeElement = (TypeElement)LazyTypeCompletionItem.this.handle.resolve((CompilationInfo)compilationController);
                        Elements elements = compilationController.getElements();
                        if (!(typeElement == null || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(typeElement) || !compilationController.getTrees().isAccessible(scope, typeElement) || !LazyTypeCompletionItem.this.isOfKind(typeElement, LazyTypeCompletionItem.this.kinds) || LazyTypeCompletionItem.this.afterExtends && typeElement.getModifiers().contains((Object)Modifier.FINAL) || LazyTypeCompletionItem.this.isInDefaultPackage(typeElement) && !LazyTypeCompletionItem.this.isInDefaultPackage(scope.getEnclosingClass()) || Utilities.isExcluded(typeElement.getQualifiedName()))) {
                            LazyTypeCompletionItem.this.delegate = JavaCompletionItem.createTypeItem(typeElement, (DeclaredType)typeElement.asType(), LazyTypeCompletionItem.this.substitutionOffset, true, compilationController.getElements().isDeprecated(typeElement), LazyTypeCompletionItem.this.insideNew, LazyTypeCompletionItem.this.addTypeVars, false);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        if (this.delegate != null) {
            this.delegate.defaultAction(jTextComponent);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(keyEvent);
        }
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)graphics, (Font)font);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (this.delegate != null) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    public int getSortPriority() {
        return 700;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    private boolean isOfKind(Element element, EnumSet<ElementKind> enumSet) {
        if (enumSet.contains((Object)element.getKind())) {
            return true;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!this.isOfKind(element2, enumSet)) continue;
            return true;
        }
        return false;
    }

    private boolean isInDefaultPackage(Element element) {
        while (element != null && element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return element != null && element.getSimpleName().length() == 0;
    }
}

