/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.query.CommentSet;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

public final class GeneratorUtilities {
    private WorkingCopy copy;

    private GeneratorUtilities(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GeneratorUtilities get(WorkingCopy copy) {
        return new GeneratorUtilities(copy);
    }

    public ClassTree insertClassMember(ClassTree clazz, Tree member) {
        assert (clazz != null && member != null);
        int idx = 0;
        GuardedDocument gdoc = null;
        SourcePositions sp = null;
        try {
            Document doc = this.copy.getDocument();
            if (doc == null) {
                DataObject data = DataObject.find((FileObject)this.copy.getFileObject());
                EditorCookie cookie = (EditorCookie)data.getCookie(EditorCookie.class);
                doc = cookie.openDocument();
            }
            if (doc != null && doc instanceof GuardedDocument) {
                gdoc = (GuardedDocument)doc;
                sp = this.copy.getTrees().getSourcePositions();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TreeUtilities utils = this.copy.getTreeUtilities();
        CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
        Tree lastMember = null;
        for (Tree tree : clazz.getMembers()) {
            TreePath path = TreePath.getPath(compilationUnit, tree);
            if (!(path != null && utils.isSynthetic(path) || ClassMemberComparator.compare(member, tree) >= 0)) {
                if (gdoc == null) break;
                int pos = (int)(lastMember != null ? sp.getEndPosition(compilationUnit, lastMember) : sp.getStartPosition(compilationUnit, clazz));
                pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                if ((long)pos <= sp.getStartPosition(compilationUnit, tree)) break;
            }
            ++idx;
            lastMember = tree;
        }
        return this.copy.getTreeMaker().insertClassMember(clazz, idx, member);
    }

    public ClassTree insertClassMembers(ClassTree clazz, Iterable<? extends Tree> members) {
        assert (members != null);
        for (Tree tree : members) {
            clazz = this.insertClassMember(clazz, tree);
        }
        return clazz;
    }

    public List<? extends MethodTree> createAllAbstractMethodImplementations(TypeElement clazz) {
        return this.createAbstractMethodImplementations(clazz, this.copy.getElementUtilities().findUnimplementedMethods(clazz));
    }

    public List<? extends MethodTree> createAbstractMethodImplementations(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createAbstractMethodImplementation(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createAbstractMethodImplementation(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, (DeclaredType)clazz.asType());
    }

    public List<? extends MethodTree> createOverridingMethods(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createOverridingMethod(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createOverridingMethod(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, (DeclaredType)clazz.asType());
    }

    public MethodTree createMethod(DeclaredType asMemberOf, ExecutableElement method) {
        TreeMaker make = this.copy.getTreeMaker();
        Set<Modifier> mods = method.getModifiers();
        EnumSet<Modifier> flags = mods.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mods);
        flags.remove((Object)Modifier.ABSTRACT);
        flags.remove((Object)Modifier.NATIVE);
        ExecutableType et = (ExecutableType)method.asType();
        try {
            et = (ExecutableType)this.copy.getTypes().asMemberOf(asMemberOf, method);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeVariable typeVariable : et.getTypeVariables()) {
            ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
            TypeMirror bound = typeVariable.getUpperBound();
            if (bound.getKind() != TypeKind.NULL) {
                if (bound.getKind() == TypeKind.DECLARED) {
                    Symbol.ClassSymbol boundSymbol = (Symbol.ClassSymbol)((DeclaredType)bound).asElement();
                    if (boundSymbol.getSimpleName().length() == 0 && (boundSymbol.flags() & 0x1000000L) != 0L) {
                        bounds.add((ExpressionTree)make.Type(boundSymbol.getSuperclass()));
                        for (Type iface : boundSymbol.getInterfaces()) {
                            bounds.add((ExpressionTree)make.Type(iface));
                        }
                    } else if (!boundSymbol.getQualifiedName().contentEquals("java.lang.Object")) {
                        bounds.add((ExpressionTree)make.Type(bound));
                    }
                } else {
                    bounds.add((ExpressionTree)make.Type(bound));
                }
            }
            typeParams.add(make.TypeParameter(typeVariable.asElement().getSimpleName(), bounds));
        }
        Tree returnType = make.Type(et.getReturnType());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        boolean isVarArgs = method.isVarArgs();
        Iterator<? extends VariableElement> formArgNames = method.getParameters().iterator();
        Iterator<? extends TypeMirror> formArgTypes = et.getParameterTypes().iterator();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        while (formArgNames.hasNext() && formArgTypes.hasNext()) {
            VariableElement formArgName = formArgNames.next();
            TypeMirror formArgType = formArgTypes.next();
            if (isVarArgs && !formArgNames.hasNext()) {
                parameterModifiers = make.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList.add(make.Variable(parameterModifiers, formArgName.getSimpleName(), make.Type(formArgType), null));
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : et.getThrownTypes()) {
            throwsList.add((ExpressionTree)make.Type(typeMirror));
        }
        ModifiersTree mt = make.Modifiers(flags, Collections.emptyList());
        return make.Method(mt, (CharSequence)method.getSimpleName(), returnType, typeParams, arrayList, throwsList, "{}", null);
    }

    public MethodTree createConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(clazz.getKind() == ElementKind.ENUM ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
        if (constructor != null) {
            ExecutableType constructorType;
            ExecutableType executableType = constructorType = clazz.getSuperclass().getKind() == TypeKind.DECLARED ? (ExecutableType)this.copy.getTypes().asMemberOf((DeclaredType)clazz.getSuperclass(), constructor) : null;
            if (!constructor.getParameters().isEmpty()) {
                Iterator<? extends TypeMirror> parameterTypes;
                ArrayList<IdentifierTree> arrayList = new ArrayList<IdentifierTree>();
                Iterator<? extends VariableElement> iterator = constructor.getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = parameterTypes = constructorType != null ? constructorType.getParameterTypes().iterator() : null;
                while (iterator.hasNext()) {
                    VariableElement ve = iterator.next();
                    Name simpleName = ve.getSimpleName();
                    TypeMirror type = parameterTypes != null ? parameterTypes.next() : ve.asType();
                    parameters.add(make.Variable(parameterModifiers, simpleName, make.Type(type), null));
                    arrayList.add(make.Identifier(simpleName));
                }
                statements.add(make.ExpressionStatement(make.MethodInvocation(Collections.emptyList(), make.Identifier("super"), arrayList)));
            }
            constructorType = constructorType != null ? constructorType : (ExecutableType)constructor.asType();
            for (TypeMirror typeMirror : constructorType.getThrownTypes()) {
                throwsList.add((ExpressionTree)make.Type(typeMirror));
            }
        }
        for (VariableElement variableElement : fields) {
            TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), variableElement);
            parameters.add(make.Variable(parameterModifiers, variableElement.getSimpleName(), make.Type(typeMirror), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableElement.getSimpleName()), make.Identifier(variableElement.getSimpleName()))));
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"<init>", null, Collections.emptyList(), parameters, throwsList, body, null);
    }

    public MethodTree createConstructor(ClassTree clazz, Iterable<? extends VariableTree> fields) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(this.copy.getTreeUtilities().isEnum(clazz) ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableTree variableTree : fields) {
            parameters.add(make.Variable(parameterModifiers, variableTree.getName(), variableTree.getType(), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableTree.getName()), make.Identifier(variableTree.getName()))));
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"<init>", null, Collections.emptyList(), parameters, Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(type), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(VariableTree field) {
        assert (field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        Name name = field.getName();
        assert (name.length() > 0);
        Tree type = field.getType();
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)type).getPrimitiveTypeKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, type, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, make.Type(type), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(field.getEnclosingElement().getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(ClassTree clazz, VariableTree field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        Name name = field.getName();
        assert (name.length() > 0);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, field.getType(), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(clazz.getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public <T extends Tree> T importFQNs(T original) {
        TranslateIdentifier translator = new TranslateIdentifier(this.copy, false, true, null);
        return (T)translator.translate(original);
    }

    public <T extends Tree> T importComments(T original, CompilationUnitTree cut) {
        try {
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)cut;
            TokenSequence seq = ((SourceFileObject)unit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
            TranslateIdentifier translator = new TranslateIdentifier((CompilationInfo)this.copy, true, false, (TokenSequence<JavaTokenId>)seq, unit);
            translator.translate(original);
            return original;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return original;
        }
    }

    public void copyComments(Tree source, Tree target, boolean preceding) {
        CommentHandlerService handler = CommentHandlerService.instance(this.copy.impl.getJavacTask().getContext());
        CommentSetImpl s = handler.getComments(source);
        TreeUtilities.ensureCommentsMapped(this.copy, source, s);
        CommentSetImpl t = handler.getComments(target);
        if (preceding) {
            t.addComments(CommentSet.RelativePosition.PRECEDING, s.getComments(CommentSet.RelativePosition.PRECEDING));
        } else {
            t.addComments(CommentSet.RelativePosition.INLINE, s.getComments(CommentSet.RelativePosition.INLINE));
            t.addComments(CommentSet.RelativePosition.TRAILING, s.getComments(CommentSet.RelativePosition.TRAILING));
        }
    }

    private MethodTree createMethod(ExecutableElement element, DeclaredType type) {
        SpecificationVersion version15;
        SpecificationVersion specificationVersion;
        BlockTree body;
        TreeMaker make = this.copy.getTreeMaker();
        boolean isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT);
        if (isAbstract) {
            ArrayList<ThrowTree> blockStatements = new ArrayList<ThrowTree>();
            TypeElement uoe = this.copy.getElements().getTypeElement("java.lang.UnsupportedOperationException");
            if (uoe != null) {
                NewClassTree newClassTree = make.NewClass(null, Collections.emptyList(), make.QualIdent(uoe), Collections.singletonList(make.Literal("Not supported yet.")), null);
                blockStatements.add(make.Throw(newClassTree));
            }
            body = make.Block(blockStatements, false);
        } else {
            ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : element.getParameters()) {
                arguments.add(make.Identifier(variableElement.getSimpleName()));
            }
            MethodInvocationTree inv = make.MethodInvocation(Collections.emptyList(), make.MemberSelect((ExpressionTree)make.Identifier("super"), element.getSimpleName()), arguments);
            StatementTree statementTree = this.copy.getTypes().getNoType(TypeKind.VOID) == element.getReturnType() ? make.ExpressionStatement(inv) : make.Return(inv);
            body = make.Block(Collections.singletonList(statementTree), false);
        }
        MethodTree prototype = this.createMethod(type, element);
        ModifiersTree mt = prototype.getModifiers();
        if (GeneratorUtilities.supportsOverride(this.copy) && (specificationVersion = new SpecificationVersion(SourceLevelQuery.getSourceLevel((FileObject)this.copy.getFileObject()))).compareTo((Object)(version15 = new SpecificationVersion("1.5"))) >= 0) {
            boolean generate = true;
            if (specificationVersion.compareTo((Object)version15) == 0) {
                boolean bl = generate = !element.getEnclosingElement().getKind().isInterface();
            }
            if (generate) {
                mt = make.addModifiersAnnotation(prototype.getModifiers(), make.Annotation(make.Identifier("Override"), Collections.emptyList()));
            }
        }
        return make.Method(mt, (CharSequence)prototype.getName(), prototype.getReturnType(), prototype.getTypeParameters(), prototype.getParameters(), prototype.getThrows(), body, null);
    }

    private static boolean supportsOverride(CompilationInfo info) {
        return info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static StringBuilder getCapitalizedName(CharSequence cs) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(1))) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb;
    }

    private void tagFirst(List<MethodTree> methods) {
        BlockTree body;
        if (methods.size() > 0 && (body = methods.get(0).getBody()) != null && !body.getStatements().isEmpty()) {
            this.copy.tag(body.getStatements().get(0), "methodBodyTag");
        }
    }

    private static class ClassMemberComparator {
        private ClassMemberComparator() {
        }

        public static int compare(Tree tree1, Tree tree2) {
            if (tree1 == tree2) {
                return 0;
            }
            return ClassMemberComparator.getSortPriority(tree1) - ClassMemberComparator.getSortPriority(tree2);
        }

        private static int getSortPriority(Tree tree) {
            int ret = 0;
            ModifiersTree modifiers = null;
            switch (tree.getKind()) {
                case CLASS: {
                    ret = 4000;
                    modifiers = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree mt = (MethodTree)tree;
                    ret = mt.getName().contentEquals("<init>") ? 200 : 300;
                    modifiers = mt.getModifiers();
                    break;
                }
                case VARIABLE: {
                    ret = 100;
                    modifiers = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiers != null && !modifiers.getFlags().contains((Object)Modifier.STATIC)) {
                ret += 1000;
            }
            return ret;
        }
    }
}

