/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import javax.swing.UIManager;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LevelOfDetailsWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.openide.util.NbBundle;

public class EdgeWidget
extends ConnectionWidget {
    public static final int DISABLED = 0;
    public static final int GRAYED = 1;
    public static final int REGULAR = 2;
    public static final int HIGHLIGHTED = 3;
    public static final int HIGHLIGHTED_PRIMARY = 4;
    private static float[] hsbVals = new float[3];
    private ArtifactGraphEdge edge;
    private int state = 2;
    private boolean isConflict;
    private int edgeConflictType;
    private LabelWidget conflictVersion;
    private Widget versionW;
    private Stroke origStroke;

    public EdgeWidget(DependencyGraphScene dependencyGraphScene, ArtifactGraphEdge artifactGraphEdge) {
        super((Scene)dependencyGraphScene);
        this.edge = artifactGraphEdge;
        this.origStroke = this.getStroke();
        this.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.isConflict = artifactGraphEdge.getTarget().getState() == 2;
        this.edgeConflictType = this.getConflictType();
        this.updateVersionW(this.isConflict);
    }

    private void updateVersionW(boolean bl) {
        DependencyGraphScene dependencyGraphScene = (DependencyGraphScene)this.getScene();
        int n = dependencyGraphScene.getGraphNodeRepresentant(this.edge.getTarget()).getConflictType();
        if (this.versionW == null) {
            if (bl || n != 0) {
                Color color;
                this.versionW = new LevelOfDetailsWidget((Scene)dependencyGraphScene, 0.5, 0.7, Double.MAX_VALUE, Double.MAX_VALUE);
                this.conflictVersion = new LabelWidget((Scene)dependencyGraphScene, this.edge.getTarget().getArtifact().getVersion());
                if (bl && (color = EdgeWidget.getConflictColor(this.edgeConflictType)) != null) {
                    this.conflictVersion.setForeground(color);
                }
                this.versionW.addChild((Widget)this.conflictVersion);
                this.addChild(this.versionW);
                this.setConstraint(this.versionW, LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT, 0.5f);
            }
        } else if (!bl && n == 0) {
            this.removeChild(this.versionW);
        }
    }

    public void setState(int n) {
        this.state = n;
        this.updateAppearance();
    }

    void modelChanged() {
        this.edgeConflictType = this.getConflictType();
        boolean bl = this.isConflict = this.edge.getTarget().getState() == 2;
        if (this.isConflict && this.edgeConflictType == 0) {
            this.isConflict = false;
        }
        this.updateVersionW(this.isConflict);
        this.updateAppearance();
    }

    private void updateAppearance() {
        Object object;
        Color color;
        Color color2;
        Color color3 = UIManager.getColor("textInactiveText");
        if (color3 == null) {
            color3 = Color.LIGHT_GRAY;
        }
        if ((color2 = UIManager.getColor("textText")) == null) {
            color2 = Color.BLACK;
        }
        if ((color = EdgeWidget.getConflictColor(this.edgeConflictType)) == null) {
            color = color2;
        }
        Stroke stroke = this.origStroke;
        Color color4 = color2;
        switch (this.state) {
            case 2: {
                color4 = this.edge.isPrimary() ? EdgeWidget.middleColor(color2, color3) : (this.isConflict ? color : color3);
                break;
            }
            case 1: {
                color4 = this.isConflict ? EdgeWidget.deriveColor(color, 0.7f) : color3;
                break;
            }
            case 4: {
                stroke = new BasicStroke(3.0f);
            }
            case 3: {
                Color color5 = color4 = this.isConflict ? color : color2;
            }
        }
        if (this.state != 0) {
            object = new StringBuilder("<html>");
            if (this.isConflict) {
                DependencyGraphScene dependencyGraphScene = (DependencyGraphScene)this.getScene();
                DependencyNode dependencyNode = dependencyGraphScene.getGraphNodeRepresentant(this.edge.getTarget()).getArtifact();
                String string = NbBundle.getMessage(EdgeWidget.class, (String)(this.edgeConflictType == 2 ? "TIP_VersionConflict" : "TIP_VersionWarning"), (Object)dependencyNode.getArtifact().getVersion(), (Object)dependencyNode.getParent().getArtifact().getArtifactId());
                this.conflictVersion.setToolTipText(string);
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("<br>");
            }
            ((StringBuilder)object).append("<i>");
            if (this.edge.isPrimary()) {
                ((StringBuilder)object).append(NbBundle.getMessage(EdgeWidget.class, (String)"TIP_Primary"));
            } else {
                ((StringBuilder)object).append(NbBundle.getMessage(EdgeWidget.class, (String)"TIP_Secondary"));
            }
            ((StringBuilder)object).append("</i>");
            ((StringBuilder)object).append("</html>");
            this.setToolTipText(((StringBuilder)object).toString());
        } else {
            this.setToolTipText(null);
        }
        if (this.conflictVersion != null) {
            this.conflictVersion.setForeground(color4);
            object = this.getScene().getDefaultFont();
            this.conflictVersion.setFont((Font)(this.state == 3 || this.state == 4 ? ArtifactWidget.getReadable(this.getScene(), (Font)object) : object));
        }
        this.setVisible(this.state != 0);
        this.setStroke(stroke);
        object = (DependencyGraphScene)this.getScene();
        if (((DependencyGraphScene)((Object)object)).isAnimated()) {
            object.getSceneAnimator().animateForegroundColor((Widget)this, color4);
        } else {
            this.setForeground(color4);
        }
    }

    private int getConflictType() {
        DefaultArtifactVersion defaultArtifactVersion;
        ArtifactGraphNode artifactGraphNode = ((DependencyGraphScene)this.getScene()).getGraphNodeRepresentant(this.edge.getTarget());
        DefaultArtifactVersion defaultArtifactVersion2 = new DefaultArtifactVersion(this.edge.getTarget().getArtifact().getVersion());
        int n = defaultArtifactVersion2.compareTo((Object)(defaultArtifactVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion())));
        return n > 0 ? 2 : (n < 0 ? 1 : 0);
    }

    private static Color getConflictColor(int n) {
        return n == 2 ? ArtifactWidget.CONFLICT : (n == 1 ? ArtifactWidget.WARNING : null);
    }

    static Color deriveColor(Color color, float f) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbVals);
        EdgeWidget.hsbVals[1] = Math.min(1.0f, hsbVals[1] * f);
        return Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2]);
    }

    private static Color middleColor(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }
}

