/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;

public final class TokenSequence<T extends TokenId> {
    private final TokenList<T> tokenList;
    private AbstractToken<T> token;
    private int tokenIndex;
    private int tokenOffset = -1;
    private final int modCount;

    TokenSequence(TokenList<T> tokenList) {
        this.tokenList = tokenList;
        this.modCount = tokenList.modCount();
    }

    public Language<T> language() {
        return LexerUtilsConstants.innerLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    public Token<T> token() {
        return this.token;
    }

    public Token<T> offsetToken() {
        this.checkTokenNotNull();
        if (this.token.isFlyweight()) {
            this.token = this.tokenList.replaceFlyToken(this.tokenIndex, this.token, this.offset());
        }
        return this.token;
    }

    public int offset() {
        this.checkTokenNotNull();
        if (this.tokenOffset == -1) {
            this.tokenOffset = this.tokenList.tokenOffset(this.tokenIndex);
        }
        return this.tokenOffset;
    }

    public int index() {
        return this.tokenIndex;
    }

    public TokenSequence<?> embedded() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null, false);
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> embeddedLanguage) {
        this.checkTokenNotNull();
        return this.embeddedImpl(Collections.singleton(embeddedLanguage), false);
    }

    public TokenSequence<?> embeddedJoined() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null, true);
    }

    public <ET extends TokenId> TokenSequence<ET> embeddedJoined(Language<ET> embeddedLanguage) {
        this.checkTokenNotNull();
        return this.embeddedImpl(Collections.singleton(embeddedLanguage), true);
    }

    private <ET extends TokenId> TokenSequence<ET> embeddedImpl(Set<Language<?>> embeddedLanguagesSet, boolean joined) {
        if (this.token.isFlyweight()) {
            return null;
        }
        EmbeddedTokenList embeddedTokenList = EmbeddingContainer.embeddedTokenList(this.tokenList, this.tokenIndex, embeddedLanguagesSet, true);
        if (embeddedTokenList != null) {
            TokenSequence tse;
            JoinTokenList joinTokenList;
            embeddedTokenList.embeddingContainer().updateStatus();
            if (joined && (joinTokenList = embeddedTokenList.joinTokenList()) != null) {
                tse = new TokenSequence(joinTokenList);
                tse.moveIndex(joinTokenList.activeStartJoinIndex());
            } else {
                tse = new TokenSequence(embeddedTokenList);
            }
            return tse;
        }
        return null;
    }

    public boolean createEmbedding(Language<?> embeddedLanguage, int startSkipLength, int endSkipLength) {
        return this.createEmbedding(embeddedLanguage, startSkipLength, endSkipLength, false);
    }

    public boolean createEmbedding(Language<?> embeddedLanguage, int startSkipLength, int endSkipLength, boolean joinSections) {
        this.checkTokenNotNull();
        return EmbeddingContainer.createEmbedding(this.tokenList, this.tokenIndex, embeddedLanguage, startSkipLength, endSkipLength, joinSections);
    }

    public boolean removeEmbedding(Language<?> embeddedLanguage) {
        this.checkTokenNotNull();
        return EmbeddingContainer.removeEmbedding(this.tokenList, this.tokenIndex, embeddedLanguage);
    }

    public boolean moveNext() {
        TokenOrEmbedding<T> tokenOrEmbedding;
        this.checkModCount();
        if (this.token != null) {
            ++this.tokenIndex;
        }
        if ((tokenOrEmbedding = this.tokenList.tokenOrEmbedding(this.tokenIndex)) != null) {
            AbstractToken<T> origToken = this.token;
            this.token = tokenOrEmbedding.token();
            if (this.tokenOffset != -1) {
                this.tokenOffset = origToken != null ? (this.tokenList.isContinuous() || this.token.isFlyweight() ? (this.tokenOffset += origToken.length()) : -1) : -1;
            }
            return true;
        }
        if (this.token != null) {
            --this.tokenIndex;
        }
        return false;
    }

    public boolean movePrevious() {
        this.checkModCount();
        if (this.tokenIndex > 0) {
            AbstractToken<T> origToken = this.token;
            --this.tokenIndex;
            this.token = this.tokenList.tokenOrEmbedding(this.tokenIndex).token();
            if (this.tokenOffset != -1) {
                this.tokenOffset = origToken != null ? (this.tokenList.isContinuous() || origToken.isFlyweight() ? (this.tokenOffset -= this.token.length()) : -1) : -1;
            }
            return true;
        }
        return false;
    }

    public int moveIndex(int index) {
        this.checkModCount();
        if (index >= 0) {
            TokenOrEmbedding<T> tokenOrEmbedding = this.tokenList.tokenOrEmbedding(index);
            if (tokenOrEmbedding != null) {
                this.resetTokenIndex(index, -1);
            } else {
                this.resetTokenIndex(this.tokenCount(), -1);
            }
        } else {
            this.resetTokenIndex(0, -1);
        }
        return index - this.tokenIndex;
    }

    public void moveStart() {
        this.moveIndex(0);
    }

    public void moveEnd() {
        this.moveIndex(this.tokenCount());
    }

    public int move(int offset) {
        this.checkModCount();
        int[] indexAndTokenOffset = this.tokenList.tokenIndex(offset);
        if (indexAndTokenOffset[0] != -1) {
            this.resetTokenIndex(indexAndTokenOffset[0], indexAndTokenOffset[1]);
        } else {
            this.resetTokenIndex(0, -1);
        }
        return offset - indexAndTokenOffset[1];
    }

    public boolean isEmpty() {
        return this.tokenIndex == 0 && this.tokenList.tokenOrEmbedding(0) == null;
    }

    public int tokenCount() {
        this.checkModCount();
        return this.tokenList.tokenCount();
    }

    public TokenSequence<T> subSequence(int startOffset) {
        return this.subSequence(startOffset, Integer.MAX_VALUE);
    }

    public TokenSequence<T> subSequence(int startOffset, int endOffset) {
        TokenList<T> tl;
        this.checkModCount();
        if (this.tokenList.getClass() == SubSequenceTokenList.class) {
            SubSequenceTokenList stl = (SubSequenceTokenList)this.tokenList;
            tl = stl.delegate();
            startOffset = Math.max(startOffset, stl.limitStartOffset());
            endOffset = Math.min(endOffset, stl.limitEndOffset());
        } else {
            tl = this.tokenList;
        }
        return new TokenSequence<T>(new SubSequenceTokenList<T>(tl, startOffset, endOffset));
    }

    public boolean isValid() {
        return this.tokenList.modCount() == this.modCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("TokenSequence for ").append(this.tokenList.languagePath().mimePath());
        sb.append(" at tokenIndex=").append(this.tokenIndex);
        sb.append(". TokenList contains ").append(this.tokenList.tokenCount()).append(" tokens:\n");
        LexerUtilsConstants.appendTokenList(sb, this.tokenList, this.tokenIndex, 0, Integer.MAX_VALUE, true, 0, true);
        sb.append('\n');
        return sb.toString();
    }

    private void resetTokenIndex(int index, int offset) {
        this.tokenIndex = index;
        this.token = null;
        this.tokenOffset = offset;
    }

    private void checkTokenNotNull() {
        if (this.token == null) {
            throw new IllegalStateException("Caller of TokenSequence forgot to call moveNext/Previous() or it returned false (no more tokens)\n" + this);
        }
    }

    private void checkModCount() {
        if (this.tokenList.modCount() != this.modCount) {
            throw new ConcurrentModificationException("Caller uses obsolete token sequence which is no longer valid. Underlying token hierarchy has been modified: modCount=" + this.modCount + " != upToDateModCount=" + this.tokenList.modCount() + "\nPlease report against caller's module which needs to be fixed (not the lexer module).");
        }
    }
}

