/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.callback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.CallbackFactory;
import org.jruby.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.runtime.callback.ReflectionCallback;

public class ReflectionCallbackFactory
extends CallbackFactory {
    private final Class type;

    public ReflectionCallbackFactory(Class type) {
        this.type = type;
    }

    @Override
    @Deprecated
    public Callback getMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), false);
    }

    @Override
    @Deprecated
    public Callback getFastMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), true);
    }

    @Deprecated
    public Callback getFastMethod(String rubyName, String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), true);
    }

    @Override
    @Deprecated
    public Callback getMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, false, Arity.singleArgument(), false);
    }

    @Override
    @Deprecated
    public Callback getFastMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, false, Arity.singleArgument(), true);
    }

    @Deprecated
    public Callback getFastMethod(String rubyName, String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, false, Arity.singleArgument(), true);
    }

    @Override
    @Deprecated
    public Callback getMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, false, Arity.fixed(2), false);
    }

    @Override
    @Deprecated
    public Callback getFastMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, false, Arity.fixed(2), true);
    }

    @Deprecated
    public Callback getFastMethod(String rubyName, String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, false, Arity.fixed(2), true);
    }

    @Override
    @Deprecated
    public Callback getMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, false, Arity.fixed(3), false);
    }

    @Override
    @Deprecated
    public Callback getFastMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, false, Arity.fixed(3), true);
    }

    @Deprecated
    public Callback getFastMethod(String rubyName, String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, false, Arity.fixed(3), true);
    }

    @Override
    @Deprecated
    public Callback getSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), false);
    }

    @Override
    @Deprecated
    public Callback getFastSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), true);
    }

    @Override
    @Deprecated
    public Callback getSingletonMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, true, Arity.singleArgument(), false);
    }

    @Override
    @Deprecated
    public Callback getFastSingletonMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, true, Arity.singleArgument(), true);
    }

    @Override
    @Deprecated
    public Callback getSingletonMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, true, Arity.fixed(2), false);
    }

    @Override
    @Deprecated
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, true, Arity.fixed(2), true);
    }

    @Override
    @Deprecated
    public Callback getSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, true, Arity.fixed(3), false);
    }

    @Override
    @Deprecated
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, true, Arity.fixed(3), true);
    }

    @Override
    @Deprecated
    public Callback getBlockMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject.class, IRubyObject.class}, false, true, Arity.fixed(2), false);
    }

    @Override
    public CompiledBlockCallback getBlockCallback(String method, final Object scriptObject) {
        try {
            final Method blockMethod = scriptObject.getClass().getMethod(method, ThreadContext.class, IRubyObject.class, IRubyObject.class);
            return new CompiledBlockCallback(){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject args) {
                    try {
                        return (IRubyObject)blockMethod.invoke(scriptObject, context, self, args);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @Override
    @Deprecated
    public Callback getOptSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), false);
    }

    @Override
    @Deprecated
    public Callback getFastOptSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), true);
    }

    @Override
    @Deprecated
    public Callback getOptMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), false);
    }

    @Override
    @Deprecated
    public Callback getFastOptMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), true);
    }

    @Deprecated
    public Callback getFastOptMethod(String rubyName, String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), true);
    }
}

