/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.socket.RubyIPSocket;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;
import org.jruby.util.ByteList;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUDPSocket(runtime, klass);
        }
    };

    static void createUDPSocket(Ruby runtime) {
        RubyClass rb_cUDPSocket = runtime.defineClass("UDPSocket", runtime.fastGetClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        rb_cUDPSocket.includeModule(runtime.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cUDPSocket.defineAnnotatedMethods(RubyUDPSocket.class);
        runtime.getObject().fastSetConstant("UDPsocket", rb_cUDPSocket);
    }

    public RubyUDPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        try {
            DatagramChannel channel = DatagramChannel.open();
            this.initSocket(new ChannelDescriptor(channel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject protocol) {
        return this.initialize();
    }

    public IRubyObject setsockopt(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        InetSocketAddress addr = null;
        try {
            addr = host.isNil() ? new InetSocketAddress(RubyNumeric.fix2int(port)) : new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).socket().bind(addr);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (SocketException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (Error e) {
            if (e.getCause() instanceof SocketException) {
                throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
            }
            throw e;
        }
    }

    @JRubyMethod
    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        try {
            InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).connect(addr);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
    }

    public IRubyObject recvfrom(IRubyObject[] args) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args);
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args) {
        try {
            int length = RubyNumeric.fix2int(args[0]);
            ByteBuffer buf = ByteBuffer.allocate(length);
            ((DatagramChannel)this.getChannel()).configureBlocking(false);
            context.getThread().select(this, 1);
            InetSocketAddress sender = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(buf);
            RubyArray addressArray = this.getRuntime().newArray(new IRubyObject[]{this.getRuntime().newString("AF_INET"), this.getRuntime().newFixnum(sender.getPort()), this.getRuntime().newString(sender.getHostName()), this.getRuntime().newString(sender.getAddress().getHostAddress())});
            RubyString result = this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
            return this.getRuntime().newArray(new IRubyObject[]{result, addressArray});
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
    }

    @Override
    public IRubyObject recv(IRubyObject[] args) {
        try {
            int length = RubyNumeric.fix2int(args[0]);
            ByteBuffer buf = ByteBuffer.allocate(length);
            ((DatagramChannel)this.getChannel()).receive(buf);
            return this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recv: name or service not known");
        }
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject send(IRubyObject[] args) {
        try {
            if (args.length >= 3) {
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(args[2].convertToString().toString()), RubyNumeric.fix2int(args[3]));
                RubyString data = args[0].convertToString();
                ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
                ((DatagramChannel)this.getChannel()).send(buf, addr);
                return data.length();
            }
            RubyString data = args[0].convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
            ((DatagramChannel)this.getChannel()).write(buf);
            return data.length();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyUDPSocket sock = (RubyUDPSocket)recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(recv.getRuntime().getCurrentContext(), sock);
            return iRubyObject;
        }
        finally {
            if (sock.openFile.isOpen()) {
                sock.close();
            }
        }
    }
}

