/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Iconv"})
public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private static final ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIconv(runtime, klass);
        }
    };

    public RubyIconv(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static void createIconv(Ruby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject(), ICONV_ALLOCATOR);
        iconvClass.defineAnnotatedMethods(RubyIconv.class);
        RubyModule failure = iconvClass.defineModuleUnder("Failure");
        RubyClass argumentError = runtime.getArgumentError();
        String[] iconvErrors = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i = 0; i < iconvErrors.length; ++i) {
            RubyClass subClass = iconvClass.defineClassUnder(iconvErrors[i], argumentError, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            subClass.defineAnnotatedMethods(RubyFailure.class);
            subClass.includeModule(failure);
        }
    }

    private static String getCharset(String encoding) {
        int index = encoding.indexOf("//");
        if (index == -1) {
            return encoding;
        }
        return encoding.substring(0, index);
    }

    private static boolean isIgnore(String encoding) {
        return encoding.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject to, IRubyObject from, Block block) {
        Ruby runtime = context.getRuntime();
        RubyIconv iconv = RubyIconv.newIconv(context, recv, to, from);
        if (!block.isGiven()) {
            return iconv;
        }
        IRubyObject result = runtime.getNil();
        try {
            result = block.yield(context, iconv);
        }
        finally {
            iconv.close();
        }
        return result;
    }

    private static RubyIconv newIconv(ThreadContext context, IRubyObject recv, IRubyObject to, IRubyObject from) {
        RubyClass klazz = (RubyClass)recv;
        return (RubyIconv)klazz.newInstance(context, new IRubyObject[]{to, from}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, required=2, frame=true)
    public IRubyObject initialize(IRubyObject arg1, IRubyObject arg2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        if (!arg1.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg1.getMetaClass() + " into String");
        }
        if (!arg2.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg2.getMetaClass() + " into String");
        }
        String to = arg1.convertToString().toString();
        String from = arg2.convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(from)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(to)).newEncoder();
            if (!RubyIconv.isIgnore(from)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            if (!RubyIconv.isIgnore(to)) {
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException e) {
            throw runtime.newInvalidEncoding("invalid encoding");
        }
        catch (UnsupportedCharsetException e) {
            throw runtime.newInvalidEncoding("invalid encoding");
        }
        catch (Exception e) {
            throw runtime.newSystemCallError(e.toString());
        }
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.toEncoding = null;
        this.fromEncoding = null;
        return RubyString.newEmptyString(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str) {
        return this.iconv(str, 0, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str, IRubyObject startArg) {
        int start = 0;
        if (!startArg.isNil()) {
            start = RubyNumeric.fix2int(startArg);
        }
        return this.iconv(str, start, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str, IRubyObject startArg, IRubyObject endArg) {
        int start = 0;
        int end = -1;
        if (!startArg.isNil()) {
            start = RubyNumeric.fix2int(startArg);
        }
        if (!endArg.isNil()) {
            end = RubyNumeric.fix2int(endArg);
        }
        return this.iconv(str, start, end);
    }

    private IRubyObject iconv(IRubyObject str, int start, int end) {
        if (str.isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this._iconv(str.convertToString(), start, end);
    }

    public IRubyObject iconv(IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.iconv(args[0]);
            }
            case 2: {
                return this.iconv(args[0], args[1]);
            }
            case 3: {
                return this.iconv(args[0], args[1], args[2]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 1, 2);
        return null;
    }

    private IRubyObject _iconv(RubyString str, int start, int end) {
        if (this.fromEncoding == null) {
            throw this.getRuntime().newArgumentError("closed iconv");
        }
        ByteList bytes = str.getByteList();
        if (start < 0) {
            start += bytes.length();
        }
        if (end < 0) {
            end += 1 + bytes.length();
        } else if (end > bytes.length()) {
            end = bytes.length();
        }
        if (start < 0 || end < start) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin() + start, end - start);
        try {
            CharBuffer cbuf = this.fromEncoding.decode(buf);
            buf = this.toEncoding.encode(cbuf);
        }
        catch (MalformedInputException e) {
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException e) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        byte[] arr = buf.array();
        return this.getRuntime().newString(new ByteList(arr, 0, buf.limit()));
    }

    @JRubyMethod(name={"iconv"}, required=2, rest=true, meta=true)
    public static IRubyObject iconv(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(context, recv, args, "iconv");
    }

    @JRubyMethod(name={"conv"}, required=3, rest=true, meta=true)
    public static IRubyObject conv(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(context, recv, args, "conv").join(context, RubyString.newEmptyString(recv.getRuntime()));
    }

    @JRubyMethod(name={"charset_map"}, meta=true)
    public static IRubyObject charset_map_get(IRubyObject recv) {
        return recv.getRuntime().getCharsetMap();
    }

    private static String mapCharset(ThreadContext context, IRubyObject val) {
        RubyString key;
        IRubyObject tryVal;
        RubyHash charset = val.getRuntime().getCharsetMap();
        if (charset.size() > 0 && (tryVal = charset.fastARef(key = val.callMethod(context, "downcase").convertToString())) != null) {
            val = tryVal;
        }
        return val.convertToString().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyArray convertWithArgs(ThreadContext context, IRubyObject recv, IRubyObject[] args, String function) {
        assert (args.length >= 2);
        RubyArray array = context.getRuntime().newArray(args.length - 2);
        RubyIconv iconv = RubyIconv.newIconv(context, recv, args[0], args[1]);
        try {
            for (int i = 2; i < args.length; ++i) {
                array.append(iconv.iconv(args[i]));
            }
        }
        finally {
            iconv.close();
        }
        return array;
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static final ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyFailure(runtime, klass);
            }
        };

        public static RubyFailure newInstance(Ruby runtime, RubyClass excptnClass, String msg) {
            return new RubyFailure(runtime, excptnClass, msg);
        }

        protected RubyFailure(Ruby runtime, RubyClass rubyClass) {
            this(runtime, rubyClass, null);
        }

        public RubyFailure(Ruby runtime, RubyClass rubyClass, String message) {
            super(runtime, rubyClass, message);
        }

        @Override
        @JRubyMethod(name={"initialize"}, required=1, optional=2, frame=true)
        public IRubyObject initialize(IRubyObject[] args, Block block) {
            super.initialize(args, block);
            this.success = args.length >= 2 ? args[1] : this.getRuntime().getNil();
            this.failed = args.length == 3 ? args[2] : this.getRuntime().getNil();
            return this;
        }

        @JRubyMethod(name={"success"})
        public IRubyObject success() {
            return this.success;
        }

        @JRubyMethod(name={"failed"})
        public IRubyObject failed() {
            return this.failed;
        }

        @Override
        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuilder buffer = new StringBuilder("#<");
            buffer.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            buffer.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(buffer.toString());
        }
    }

    @JRubyClass(name={"Iconv::BrokenLibrary"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class BrokenLibrary {
    }

    @JRubyClass(name={"Iconv::OutOfRange"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class OutOfRange {
    }

    @JRubyClass(name={"Iconv::InvalidEncoding"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidEncoding {
    }

    @JRubyClass(name={"Iconv::InvalidCharacter"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidCharacter {
    }

    @JRubyClass(name={"Iconv::IllegalSequence"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class IllegalSequence {
    }

    @JRubyModule(name={"Iconv::Failure"})
    public static class Failure {
    }
}

